/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.service.cache.BasicCache;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.util.Assert;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;

public class CacheImpl
implements BasicCache {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final CacheManager ehCacheManager;
    private static final String USER_CACHE = "com.atlassian.crowd.integration-user";
    private static final String USERNAMES_CACHE = "com.atlassian.crowd.integration-usernames";
    private static final String GROUP_CACHE = "com.atlassian.crowd.integration-group";
    private static final String GROUPNAMES_CACHE = "com.atlassian.crowd.integration-groupnames";
    private static final String PARENT_GROUPS_CACHE = "com.atlassian.crowd.integration-parentgroup";
    private static final String GROUP_MEMBERSHIP_CACHE = "com.atlassian.crowd.integration-group-membership";
    private static final String ALL_USER_MEMBERSHIPS_CACHE = "com.atlassian.crowd.integration-all-memberships";
    private static final String ALL_GROUP_MEMBERS_CACHE = "com.atlassian.crowd.integration-all-group-members";
    private static final String IS_USER_OR_GROUP_CACHE = "com.atlassian.crowd.integration-is-user-or-group";
    private static final String USERNAMES_KEY = "usernames";
    private static final String GROUPNAMES_KEY = "groupnames";

    public CacheImpl(URL configLocation) {
        this(CacheManager.create((URL)configLocation));
    }

    public CacheImpl(CacheManager ehCacheManager) {
        this.ehCacheManager = ehCacheManager;
        this.createIfNeeded(USER_CACHE);
        this.createIfNeeded(USERNAMES_CACHE);
        this.createIfNeeded(GROUP_CACHE);
        this.createIfNeeded(GROUPNAMES_CACHE);
        this.createIfNeeded(PARENT_GROUPS_CACHE);
        this.createIfNeeded(GROUP_MEMBERSHIP_CACHE);
        this.createIfNeeded(ALL_USER_MEMBERSHIPS_CACHE);
        this.createIfNeeded(ALL_GROUP_MEMBERS_CACHE);
        this.createIfNeeded(IS_USER_OR_GROUP_CACHE);
    }

    private void createIfNeeded(String cacheName) {
        if (!this.ehCacheManager.cacheExists(cacheName)) {
            this.ehCacheManager.addCache(cacheName);
        }
    }

    private Cache getUserCache() {
        return this.ehCacheManager.getCache(USER_CACHE);
    }

    private Cache getUserNamesCache() {
        return this.ehCacheManager.getCache(USERNAMES_CACHE);
    }

    private Cache getGroupCache() {
        return this.ehCacheManager.getCache(GROUP_CACHE);
    }

    private Cache getGroupNamesCache() {
        return this.ehCacheManager.getCache(GROUPNAMES_CACHE);
    }

    private Cache getParentGroupsCache() {
        return this.ehCacheManager.getCache(PARENT_GROUPS_CACHE);
    }

    private Cache getGroupMembershipCache() {
        return this.ehCacheManager.getCache(GROUP_MEMBERSHIP_CACHE);
    }

    private Cache getUserMembershipsCache() {
        return this.ehCacheManager.getCache(ALL_USER_MEMBERSHIPS_CACHE);
    }

    private Cache getGroupMembersCache() {
        return this.ehCacheManager.getCache(ALL_GROUP_MEMBERS_CACHE);
    }

    private Cache getIsUserOrGroupCache() {
        return this.ehCacheManager.getCache(IS_USER_OR_GROUP_CACHE);
    }

    public void flush() {
        this.ehCacheManager.clearAll();
    }

    public void addOrReplaceUser(SOAPPrincipal user) {
        this.getUserCache().put(new Element((Serializable)((Object)user.getName()), (Serializable)user));
    }

    public boolean removeUser(String userName) {
        return this.getUserCache().remove((Serializable)((Object)userName));
    }

    public SOAPPrincipal getUser(String userName) {
        Element element = this.getUserCache().get((Serializable)((Object)userName));
        if (element == null) {
            return null;
        }
        return (SOAPPrincipal)element.getValue();
    }

    public List getAllUserNames() {
        Element element = this.getUserNamesCache().get((Serializable)((Object)USERNAMES_KEY));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    public void addOrReplaceAllUserNames(List userNames) {
        this.getUserNamesCache().put(new Element((Object)USERNAMES_KEY, (Object)userNames));
    }

    public SOAPGroup getGroup(String groupName) {
        Element element = this.getGroupCache().get((Serializable)((Object)groupName));
        if (element == null) {
            return null;
        }
        return (SOAPGroup)element.getValue();
    }

    public void addOrReplaceGroup(SOAPGroup group) {
        this.getGroupCache().put(new Element((Serializable)((Object)group.getName()), (Serializable)group));
    }

    public void removeGroup(String groupName) {
        this.getGroupCache().remove((Serializable)((Object)groupName));
    }

    public List getAllGroupNames() {
        Element element = this.getGroupNamesCache().get((Serializable)((Object)GROUPNAMES_KEY));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    public void addOrReplaceAllGroupNames(List groupNames) {
        this.getGroupNamesCache().put(new Element((Object)GROUPNAMES_KEY, (Object)groupNames));
    }

    public void addParentForGroup(String childGroup, String parentGroup) {
        Element element = this.getParentGroupsCache().get((Serializable)((Object)childGroup));
        if (element != null) {
            ArrayList parents = (ArrayList)element.getValue();
            if (!parents.contains(parentGroup)) {
                parents.add(parentGroup);
            }
        } else {
            ArrayList<String> parentGroups = new ArrayList<String>(1);
            parentGroups.add(parentGroup);
            element = new Element((Serializable)((Object)childGroup), parentGroups);
            this.getParentGroupsCache().put(element);
        }
    }

    public List getParentGroups(String childGroup) {
        Element element = this.getParentGroupsCache().get((Serializable)((Object)childGroup));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    public boolean containsGroupRelationships() {
        return this.getAllGroupNames() != null;
    }

    public Boolean isMemberInGroupCache(String userName, String groupName) {
        Boolean isMember = null;
        List allUsers = this.getAllMembers(groupName);
        if (allUsers != null) {
            isMember = allUsers.contains(userName);
        }
        return isMember;
    }

    public void addGroupToUser(String userName, String groupName) {
        ArrayList<String> groups = this.getAllMemberships(userName);
        if (groups == null) {
            groups = new ArrayList<String>(1);
        }
        if (!groups.contains(groupName)) {
            groups.add(groupName);
            Collections.sort(groups);
            this.addOrReplaceAllMemberships(userName, groups);
        }
    }

    public void addUserToGroup(String userName, String groupName) {
        ArrayList<String> users = this.getAllMembers(groupName);
        if (users == null) {
            users = new ArrayList<String>(1);
        }
        if (!users.contains(userName)) {
            users.add(userName);
            Collections.sort(users);
            this.addOrReplaceAllMembers(groupName, users);
        }
    }

    public void removeGroupFromUser(String userName, String groupName) {
        List groupsForUser = this.getAllMemberships(userName);
        if (groupsForUser != null) {
            groupsForUser.remove(groupName);
        }
    }

    public void removeUserFromGroup(String userName, String groupName) {
        List usersForGroup = this.getAllMembers(groupName);
        if (usersForGroup != null) {
            usersForGroup.remove(userName);
        }
    }

    public List setMembers(String groupName, String[] userNameArray) {
        Assert.notNull(groupName);
        ArrayList<String> userNames = null;
        if (userNameArray != null && userNameArray.length > 0) {
            userNames = new ArrayList<String>(Arrays.asList(userNameArray));
            this.addOrReplaceAllMembers(groupName, userNames);
        }
        return userNames;
    }

    public void removeCachedGroupMembership(String userName, String groupName) {
        Assert.notNull(userName);
        Assert.notNull(groupName);
        this.removeMembership(userName, groupName);
        this.removeGroupFromUser(userName, groupName);
    }

    public void removeCachedGroupMemberships(String groupName) {
        Assert.notNull(groupName);
        List userNames = this.getAllMembers(groupName);
        if (userNames != null) {
            Iterator userIt = userNames.iterator();
            while (userIt.hasNext()) {
                this.removeCachedGroupMembership((String)userIt.next(), groupName);
            }
        }
        this.removeAllMembers(groupName);
    }

    public void removeFromAllGroupNamesCache(String groupName) {
        Assert.notNull(groupName);
        List allGroups = this.getAllGroupNames();
        if (allGroups != null) {
            allGroups.remove(groupName);
        }
    }

    public void addToAllGroupNamesCache(String groupName) {
        Assert.notNull(groupName);
        List allGroups = this.getAllGroupNames();
        if (allGroups != null && !allGroups.contains(groupName)) {
            allGroups.add(groupName);
            Collections.sort(allGroups);
        }
    }

    public void removeCachedUser(String userName, String groupName) {
        Assert.notNull(userName);
        Assert.notNull(groupName);
        this.removeMembership(userName, groupName);
        this.removeUserFromGroup(userName, groupName);
    }

    public void removeAllMemberships(String userName) {
        Assert.notNull(userName);
        List groups = this.getAllMemberships(userName);
        if (groups != null) {
            Iterator groupIt = groups.iterator();
            while (groupIt.hasNext()) {
                this.removeCachedUser(userName, (String)groupIt.next());
            }
        }
        this.removeAllMembershipsFromUserMembershipsCache(userName);
    }

    public void setMembership(String userName, String groupName, Boolean isMember) {
        Assert.notNull(isMember);
        this.getGroupMembershipCache().put(new Element((Serializable)new UserGroupKey(userName, groupName), (Serializable)isMember));
    }

    public void removeMembership(String userName, String groupName) {
        this.getGroupMembershipCache().remove((Serializable)new UserGroupKey(userName, groupName));
    }

    public Boolean isMember(String userName, String groupName) {
        Element element = this.getGroupMembershipCache().get((Serializable)new UserGroupKey(userName, groupName));
        if (element == null) {
            return null;
        }
        return (Boolean)element.getValue();
    }

    public List getAllMemberships(String userName) {
        Element element = this.getUserMembershipsCache().get((Serializable)((Object)userName));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    public void addOrReplaceAllMemberships(String userName, List groupNames) {
        this.getUserMembershipsCache().put(new Element((Object)userName, (Object)groupNames));
    }

    public void removeAllMembershipsFromUserMembershipsCache(String userName) {
        this.getUserMembershipsCache().remove((Serializable)((Object)userName));
    }

    public List getAllMembers(String groupName) {
        Element element = this.getGroupMembersCache().get((Serializable)((Object)groupName));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    public void addOrReplaceAllMembers(String groupName, List userNames) {
        this.getGroupMembersCache().put(new Element((Object)groupName, (Object)userNames));
    }

    public void removeAllMembers(String groupName) {
        this.getGroupMembersCache().remove((Serializable)((Object)groupName));
    }

    public Boolean isUserOrGroup(String name) {
        Boolean isUserInGroup = null;
        Element element = this.getIsUserOrGroupCache().get((Serializable)((Object)name));
        if (element != null) {
            isUserInGroup = (Boolean)element.getValue();
        }
        return isUserInGroup;
    }

    public void addIsUserOrGroup(String name, Boolean isValidUserOrGroup) {
        this.getIsUserOrGroupCache().put(new Element((Serializable)((Object)name), (Serializable)isValidUserOrGroup));
    }

    public void addToAllUsers(String userName) {
        Assert.notNull(userName);
        List userNames = this.getAllUserNames();
        if (userNames != null && !userNames.contains(userName)) {
            userNames.add(userName);
            Collections.sort(userNames);
        }
    }

    public void removeFromAllUsers(String userName) {
        Assert.notNull(userName);
        List userNames = this.getAllUserNames();
        if (userNames != null) {
            userNames.remove(userName);
        }
    }

    private static class UserGroupKey
    implements Serializable {
        private String userName;
        private String groupName;

        UserGroupKey(String userName, String groupName) {
            Assert.notNull(userName);
            Assert.notNull(groupName);
            this.userName = userName;
            this.groupName = groupName;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof UserGroupKey)) {
                return false;
            }
            UserGroupKey other = (UserGroupKey)o;
            return this.userName.equals(other.userName) && this.groupName.equals(other.groupName);
        }

        public int hashCode() {
            return this.userName.hashCode() / 2 + this.groupName.hashCode() / 2;
        }
    }
}

