/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.cache.CachingManagerFactory;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.util.Assert;
import com.atlassian.user.impl.DefaultUser;
import org.apache.log4j.Logger;

public class CrowdUser
extends DefaultUser {
    private static final Logger logger = Logger.getLogger(CrowdUser.class);
    private boolean fetchedName;
    private boolean fetchedEmail;
    private SOAPPrincipal principal;
    private final transient UserManager userManager;

    public CrowdUser() {
        this.userManager = CachingManagerFactory.getUserManagerInstance();
    }

    public CrowdUser(String name, UserManager userManager) {
        super(name);
        this.userManager = userManager;
    }

    public CrowdUser(SOAPPrincipal principal, UserManager userManager) {
        Assert.notNull(principal);
        Assert.notNull(principal.getName());
        this.principal = principal;
        this.name = principal.getName();
        this.userManager = userManager;
        this.processEmail();
        this.processFullName();
    }

    public String getFullName() {
        if (!this.fetchedName) {
            this.processFullName();
        }
        return super.getFullName();
    }

    public String getEmail() {
        if (!this.fetchedEmail) {
            this.processEmail();
        }
        return super.getEmail();
    }

    private void processFullName() {
        if (!this.fetchedName) {
            StringBuffer fullName = new StringBuffer();
            String[] displayName = this.getPropertyValues("displayName");
            if (displayName.length > 0) {
                fullName.append(displayName[0]);
            } else {
                String[] fn = this.getPropertyValues("givenName");
                String[] ln = this.getPropertyValues("sn");
                if (fn.length > 0) {
                    fullName.append(fn[0]);
                }
                if (ln.length > 0) {
                    if (fullName.length() > 0) {
                        fullName.append(" ");
                    }
                    fullName.append(ln[0]);
                }
            }
            this.setFullName(fullName.toString());
            this.fetchedName = true;
        }
    }

    protected void processEmail() {
        if (!this.fetchedEmail) {
            String[] email = this.getPropertyValues("mail");
            if (email.length > 0) {
                this.setEmail(email[0]);
            } else {
                this.setEmail("");
            }
            this.fetchedEmail = true;
        }
    }

    protected String[] getPropertyValues(String key) {
        SOAPAttribute[] attributes;
        if (this.principal == null) {
            this.fetchPrincipal();
        }
        if (this.principal != null && (attributes = this.principal.getAttributes()) != null) {
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getName().equals(key)) continue;
                return attributes[i].getValues();
            }
        }
        return new String[0];
    }

    protected void fetchPrincipal() {
        try {
            if (this.principal == null) {
                this.principal = this.userManager.getUser(this.name);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }
}

