/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyUtils {
    private static final Logger logger = Logger.getLogger(PropertyUtils.class);
    private String propertyResourceName;
    private String propertyResourceLocation;

    public PropertyUtils() {
        this.propertyResourceName = "crowd.properties";
        this.init();
    }

    public PropertyUtils(String propertyResourceName) {
        this.propertyResourceName = propertyResourceName;
        this.init();
    }

    public PropertyUtils(String propertyResourceName, String propertyResourceLocation) {
        this.propertyResourceName = propertyResourceName;
        this.propertyResourceLocation = propertyResourceLocation;
    }

    private void init() {
        this.propertyResourceLocation = this.getResourceLocationFromFilesystem();
        if (this.propertyResourceLocation == null) {
            this.propertyResourceLocation = this.getResourceLocationFromClassPath(PropertyUtils.class);
        }
    }

    protected String getResourceLocationFromFilesystem() {
        String fileLocation = System.getProperty(this.propertyResourceName);
        String url = null;
        if (fileLocation != null) {
            File file = new File(fileLocation);
            if (file.exists() && file.canRead()) {
                try {
                    url = file.toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                logger.error((Object)("System property: " + this.propertyResourceName + " read but cannot access file: " + fileLocation));
            }
        }
        return url;
    }

    public String getResourceLocationFromClassPath(Class callingClass) {
        URL resource = this.getClassLoaderResource(this.propertyResourceName, callingClass);
        return resource != null ? resource.toExternalForm() : null;
    }

    public URL getClassLoaderResource(String resourceName, Class callingClass) {
        URL url = null;
        url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = PropertyUtils.class.getClassLoader().getResource(resourceName);
        }
        if (url == null) {
            url = callingClass.getClassLoader().getResource(resourceName);
        }
        return url;
    }

    public Properties getProperties() {
        Properties properties = null;
        if (this.propertyResourceLocation != null) {
            try {
                URL url = new URL(this.propertyResourceLocation);
                properties = this.getPropertiesFromStream(url.openStream());
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getPropertiesFromStream(InputStream is) {
        if (is == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            logger.error((Object)"Error loading properties from stream.", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error((Object)("Failed to close the stream: " + e.getMessage()), (Throwable)e);
            }
        }
        return props;
    }

    public String getPropertyResourceLocation() {
        return this.propertyResourceLocation;
    }

    public boolean removeProperty(String key) {
        boolean success = false;
        Properties properties = this.getProperties();
        Object currentValue = properties.remove(key);
        logger.info((Object)("Updating properties resource: " + this.propertyResourceName + " removing property with key: " + key));
        if (currentValue != null) {
            success = true;
        }
        this.storeProperties(properties);
        return success;
    }

    public void updateProperty(String key, String value) {
        Properties properties = this.getProperties();
        if (properties != null) {
            properties.setProperty(key, value);
            logger.info((Object)("Updating properties resource: " + this.propertyResourceName + " adding property: " + key + "|" + value));
            this.storeProperties(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeProperties(Properties properties) {
        OutputStream ostream = null;
        try {
            String crowdFile = URLDecoder.decode(new URL(this.propertyResourceLocation).getFile(), "UTF-8");
            ostream = new FileOutputStream(crowdFile);
            properties.store(ostream, null);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String getPropertyResourceName() {
        return this.propertyResourceName;
    }
}

