/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidPrincipalException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.cache.CacheFactory;
import com.atlassian.crowd.integration.service.cache.CachingGroupMembershipManager;
import com.atlassian.crowd.integration.service.cache.UserCache;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.atlassian.crowd.integration.util.Null;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CachingUserManager
implements UserManager {
    protected Server server;
    protected CachingGroupMembershipManager membershipManager;

    public CachingUserManager() {
    }

    public CachingUserManager(SecurityServerClient ssc) {
        this.setSecurityServerClient(ssc);
    }

    protected UserCache getCache() {
        return CacheFactory.getUserInstance();
    }

    public SOAPPrincipal getUser(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        Null.not(userName);
        SOAPPrincipal user = this.getCache().getUser(userName);
        if (user == null) {
            user = this.server.getUser(userName);
            this.getCache().addOrReplaceUser(user);
        }
        return user;
    }

    public SOAPPrincipal getUserFromToken(String token) throws RemoteException, InvalidAuthorizationTokenException, InvalidTokenException, ObjectNotFoundException {
        SOAPPrincipal user = this.server.getUserFromToken(token);
        this.getCache().addOrReplaceUser(user);
        return user;
    }

    public List searchUsers(SearchRestriction[] restrictions) throws RemoteException, InvalidAuthorizationTokenException {
        return this.server.searchUsers(restrictions);
    }

    public SOAPPrincipal addUser(SOAPPrincipal user, PasswordCredential credential) throws RemoteException, ApplicationPermissionException, InvalidCredentialException, InvalidPrincipalException, InvalidAuthorizationTokenException {
        Null.not(user);
        user = this.server.addUser(user, credential);
        this.getCache().addOrReplaceUser(user);
        this.addToAllUsers(user.getName());
        return user;
    }

    public void updateUser(SOAPPrincipal user) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
        Null.not(user);
        this.server.updateUser(user);
        this.getCache().addOrReplaceUser(user);
    }

    public void updatePassword(String userName, PasswordCredential credential) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException {
        Null.not(userName);
        this.server.updatePassword(userName, credential);
    }

    public void removeUser(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Null.not(userName);
        this.server.removeUser(userName);
        this.membershipManager.removeCachedUser(userName);
        this.getCache().removeUser(userName);
        this.removeFromAllUsers(userName);
    }

    private void addToAllUsers(String userName) {
        Null.not(userName);
        List userNames = this.getCache().getAllUserNames();
        if (userNames != null && !userNames.contains(userName)) {
            userNames.add(userName);
            Collections.sort(userNames);
        }
    }

    private void removeFromAllUsers(String userName) {
        Null.not(userName);
        List userNames = this.getCache().getAllUserNames();
        if (userNames != null) {
            userNames.remove(userName);
        }
    }

    public void setSecurityServerClient(SecurityServerClient ssc) {
        this.server = new Server(ssc);
    }

    public void setCachingGroupMembershipManager(CachingGroupMembershipManager membershipManager) {
        this.membershipManager = membershipManager;
    }

    public List getAllUserNames() throws RemoteException, InvalidAuthorizationTokenException {
        return this.getAllUserNamesFromCacheOrServer();
    }

    private List getAllUserNamesFromCacheOrServer() throws RemoteException, InvalidAuthorizationTokenException {
        List userNames = this.getCache().getAllUserNames();
        if (userNames == null) {
            this.loadAllUsers();
            userNames = this.getCache().getAllUserNames();
        }
        return userNames;
    }

    private void loadAllUsers() throws RemoteException, InvalidAuthorizationTokenException {
        List users = this.searchUsers(new SearchRestriction[0]);
        if (users != null) {
            ArrayList<String> userNames = new ArrayList<String>(users.size());
            for (SOAPPrincipal user : users) {
                userNames.add(user.getName());
                this.getCache().addOrReplaceUser(user);
            }
            this.getCache().addOrReplaceAllUserNames(userNames);
        }
    }

    public boolean isUser(String userName) throws RemoteException, InvalidAuthorizationTokenException {
        Null.not(userName);
        this.getAllUserNamesFromCacheOrServer();
        return this.getCache().getUser(userName) != null;
    }

    class Server {
        SecurityServerClient ssc;

        public Server(SecurityServerClient ssc) {
            this.ssc = ssc;
        }

        private SecurityServerClient getSSC() {
            return this.ssc;
        }

        protected SOAPPrincipal addUser(SOAPPrincipal user, PasswordCredential credential) throws RemoteException, ApplicationPermissionException, InvalidCredentialException, InvalidPrincipalException, InvalidAuthorizationTokenException {
            return this.getSSC().addPrincipal(user, credential);
        }

        protected void updateUser(SOAPPrincipal user) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
            SOAPAttribute[] attributes = user.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.length; ++i) {
                    this.getSSC().updatePrincipalAttribute(user.getName(), attributes[i]);
                }
            }
        }

        protected void updatePassword(String userName, PasswordCredential credential) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException {
            this.getSSC().updatePrincipalCredential(userName, credential);
        }

        protected void removeUser(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
            this.getSSC().removePrincipal(userName);
        }

        protected SOAPPrincipal getUser(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
            return this.getSSC().findPrincipalByName(userName);
        }

        protected SOAPPrincipal getUserFromToken(String token) throws RemoteException, InvalidAuthorizationTokenException, InvalidTokenException, ObjectNotFoundException {
            return this.getSSC().findPrincipalByToken(token);
        }

        protected List getAllUserNames() throws RemoteException, InvalidAuthorizationTokenException {
            String[] userNames = this.getSSC().findAllPrincipalNames();
            if (userNames != null) {
                return new ArrayList<String>(Arrays.asList(userNames));
            }
            return null;
        }

        public List searchUsers(SearchRestriction[] restrictions) throws RemoteException, InvalidAuthorizationTokenException {
            SOAPPrincipal[] users = this.getSSC().searchPrincipals(restrictions);
            if (users != null) {
                return Arrays.asList(users);
            }
            return null;
        }
    }
}

