/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.integration.atlassianuser.CrowdUser;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.cache.CachingManagerFactory;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.AbstractEntityQueryParser;
import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserNameTermQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class CrowdEntityQueryParser
extends AbstractEntityQueryParser
implements EntityQueryParser {
    private static final Logger logger = Logger.getLogger(CrowdEntityQueryParser.class);
    private final com.atlassian.user.UserManager userManager;
    private final GroupManager groupManager;
    private final RepositoryIdentifier repositoryIdentifier;
    private final UserManager crowdUserManager;

    public CrowdEntityQueryParser(com.atlassian.user.UserManager userManager, GroupManager groupManager, RepositoryIdentifier repositoryIdentifier) {
        this(userManager, groupManager, repositoryIdentifier, CachingManagerFactory.getUserManagerInstance());
    }

    public CrowdEntityQueryParser(com.atlassian.user.UserManager userManager, GroupManager groupManager, RepositoryIdentifier repositoryIdentifier, UserManager crowdUserManager) {
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.repositoryIdentifier = repositoryIdentifier;
        this.crowdUserManager = crowdUserManager;
    }

    public SearchResult findUsers(Query query) throws EntityException {
        try {
            ArrayList<Object> crowdResults = null;
            if (query instanceof UserNameTermQuery) {
                String term = ((TermQuery)query).getTerm();
                if (term.equals("")) {
                    Pager allUsers = this.userManager.getUsers();
                    return new DefaultSearchResult(allUsers, this.repositoryIdentifier.getKey());
                }
                User user = this.userManager.getUser(term);
                if (user != null) {
                    crowdResults = new ArrayList<Object>(1);
                    crowdResults.add(user);
                } else {
                    crowdResults = new ArrayList(0);
                }
            } else {
                SearchRestriction[] searchRestrictions = null;
                BooleanQuery bQuery = null;
                int searchTermCtr = 0;
                if (query instanceof BooleanQuery) {
                    bQuery = (BooleanQuery)query;
                    searchRestrictions = new SearchRestriction[bQuery.getQueries().size()];
                    Iterator itr = bQuery.getQueries().iterator();
                    while (itr.hasNext()) {
                        searchRestrictions[searchTermCtr] = this.processRestriction(query);
                        ++searchTermCtr;
                    }
                } else {
                    searchRestrictions = new SearchRestriction[1];
                    searchRestrictions[searchTermCtr] = this.processRestriction(query);
                }
                List wireResults = this.crowdUserManager.searchUsers(searchRestrictions);
                crowdResults = new ArrayList(wireResults.size());
                Iterator itr = wireResults.iterator();
                while (itr.hasNext()) {
                    CrowdUser crowdUser = new CrowdUser((SOAPPrincipal)itr.next(), this.crowdUserManager);
                    crowdResults.add((Object)crowdUser);
                }
            }
            DefaultPager pager = new DefaultPager(crowdResults);
            return new DefaultSearchResult((Pager)pager, this.repositoryIdentifier.getKey());
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    protected SearchRestriction processRestriction(Query query) {
        String term = ((TermQuery)query).getTerm();
        SearchRestriction searchRestriction = new SearchRestriction();
        searchRestriction.setValue(term);
        if (query instanceof EmailTermQuery) {
            searchRestriction.setName("mail");
        } else if (query instanceof FullNameTermQuery) {
            searchRestriction.setName("displayName");
        }
        return searchRestriction;
    }

    public SearchResult findGroups(Query query) throws EntityException {
        ArrayList<Group> crowdResults = null;
        if (query instanceof GroupNameTermQuery) {
            String term = ((TermQuery)query).getTerm();
            if (term.equals("")) {
                Pager allUsers = this.groupManager.getGroups();
                return new DefaultSearchResult(allUsers, this.repositoryIdentifier.getKey());
            }
            Group group = this.groupManager.getGroup(term);
            if (group != null) {
                crowdResults = new ArrayList<Group>(1);
                crowdResults.add(group);
            } else {
                crowdResults = new ArrayList(0);
            }
        }
        DefaultPager pager = new DefaultPager(crowdResults);
        return new DefaultSearchResult((Pager)pager, this.repositoryIdentifier.getKey());
    }

    public SearchResult findUsers(Query query, QueryContext context) throws EntityException {
        return this.findUsers(query);
    }

    public SearchResult findGroups(Query query, QueryContext context) throws EntityException {
        return this.findGroups(query);
    }
}

