package com.atlassian.crowd.integration.rest.entity;

import java.util.Collections;
import java.util.Set;

import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupComparator;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * Represents a Group entity.
 *
 * @since v2.1
 */
@XmlRootElement(name = "group")
@XmlAccessorType(XmlAccessType.FIELD)
public class GroupEntity implements GroupWithAttributes, Comparable<Group> {
    @XmlAttribute(name = "name")
    private String name;

    @XmlElement(name = "description")
    private String description;

    @XmlElement
    private final GroupType type;

    @XmlElement(name = "active")
    private boolean active;

    @XmlElement(name = "attributes")
    @Nullable
    private MultiValuedAttributeEntityList attributes;

    /**
     * JAXB requires a no-arg constructor.
     */
    private GroupEntity() {
        this.name = null;
        this.description = null;
        this.type = null;
        this.active = false;
    }

    public GroupEntity(final String name, final String description, final GroupType type, final boolean active) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.active = active;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public GroupType getType() {
        return type;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public long getDirectoryId() {
        return 0;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setAttributes(final MultiValuedAttributeEntityList attributes) {
        this.attributes = attributes;
    }

    @Nullable
    public MultiValuedAttributeEntityList getAttributes() {
        return attributes;
    }

    @Override
    @Nullable
    public String getExternalId() {
        return null;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).
                append("name", getName()).
                append("active", isActive()).
                append("description", getDescription()).
                append("type", getType()).
                append("externalId", getExternalId()).
                append("attributes", getAttributes()).
                toString();
    }

    @Override
    @Nullable
    public Set<String> getValues(String key) {
        return attributes != null ? attributes.getValues(key) : null;
    }

    @Override
    @Nullable
    public String getValue(String key) {
        return attributes != null ? attributes.getValue(key) : null;
    }

    @Override
    public Set<String> getKeys() {
        return attributes != null ? attributes.getKeys() : Collections.<String>emptySet();
    }

    @Override
    public boolean isEmpty() {
        return attributes == null || attributes.isEmpty();
    }

    @Override
    public int compareTo(Group o) {
        return GroupComparator.compareTo(this, o);
    }

    @Override
    public boolean equals(final Object o) {
        return GroupComparator.equalsObject(this, o);
    }

    @Override
    public int hashCode() {
        return GroupComparator.hashCode(this);
    }

    /**
     * Creates a new minimal group instance.
     *
     * @param groupName group name
     * @return minimal group instance
     */
    public static GroupEntity newMinimalInstance(String groupName) {
        return new GroupEntity(groupName, null, null, false);
    }
}
