package com.atlassian.crowd.integration.http;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

/**
 * An implementation of {@link TokenLockProvider} which doesn't do any locking
 */
public class NoOpTokenLockProvider implements TokenLockProvider {

    private final static NoOpLock LOCK = new NoOpLock();

    @Override
    public Lock getLock(String token) {
        return LOCK;
    }


    private static class NoOpLock implements Lock {

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(final long time, final TimeUnit unit) {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}
