/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.client;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.service.client.AbstractClientProperties;
import com.atlassian.crowd.service.client.ResourceLocator;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClientPropertiesImpl
extends AbstractClientProperties {
    private final Logger logger = Logger.getLogger(this.getClass());

    protected ClientPropertiesImpl() {
    }

    @Override
    public void updateProperties(Properties properties) {
        this.applicationName = this.loadAndLogPropertyString(properties, "application.name");
        this.applicationPassword = ClientPropertiesImpl.loadPropertyString(properties, "application.password");
        this.applicationAuthenticationURL = this.loadAndLogPropertyString(properties, "application.login.url");
        this.cookieTokenKey = ClientPropertiesImpl.loadPropertyString(properties, "cookie.tokenkey");
        if (this.cookieTokenKey == null) {
            this.cookieTokenKey = "crowd.token_key";
        }
        this.sessionTokenKey = this.loadAndLogPropertyString(properties, "session.tokenkey");
        this.sessionLastValidation = this.loadAndLogPropertyString(properties, "session.lastvalidation");
        this.sessionValidationInterval = this.loadPropertyLong(properties, "session.validationinterval", true);
        this.httpProxyHost = ClientPropertiesImpl.loadPropertyString(properties, "http.proxy.host");
        this.httpProxyPort = ClientPropertiesImpl.loadPropertyString(properties, "http.proxy.port");
        this.httpProxyUsername = ClientPropertiesImpl.loadPropertyString(properties, "http.proxy.username");
        this.httpProxyPassword = ClientPropertiesImpl.loadPropertyString(properties, "http.proxy.password");
        this.httpMaxConnections = ClientPropertiesImpl.loadPropertyString(properties, "http.max.connections");
        this.httpTimeout = ClientPropertiesImpl.loadPropertyString(properties, "http.timeout");
        this.socketTimeout = ClientPropertiesImpl.loadPropertyString(properties, "socket.timeout");
        PasswordCredential credentials = new PasswordCredential(this.applicationPassword);
        this.applicationAuthenticationContext = new ApplicationAuthenticationContext();
        this.applicationAuthenticationContext.setName(this.applicationName);
        this.applicationAuthenticationContext.setCredential(credentials);
        this.baseURL = this.loadBaseURL(properties);
    }

    private long loadPropertyLong(Properties properties, String propertyName, boolean logProperty) {
        long propertyValue = 0L;
        String propertyValueAsString = logProperty ? this.loadAndLogPropertyString(properties, propertyName) : ClientPropertiesImpl.loadPropertyString(properties, propertyName);
        if (propertyValueAsString != null) {
            propertyValue = Long.parseLong(propertyValueAsString);
        }
        return propertyValue;
    }

    public static String loadPropertyString(Properties properties, String propertyName) {
        String propertyValue = StringUtils.trimToNull((String)System.getProperty("crowd.property." + propertyName));
        if (propertyValue == null) {
            propertyValue = StringUtils.trimToNull((String)ClientPropertiesImpl.loadPropertyFromEnv(propertyName));
        }
        if (propertyValue == null && properties != null && properties.containsKey(propertyName)) {
            propertyValue = StringUtils.trimToNull((String)properties.getProperty(propertyName));
        }
        return propertyValue;
    }

    private static String loadPropertyFromEnv(String propertyName) {
        if (Boolean.getBoolean("atlassian.use.environment.variables")) {
            String envPropertyName = "CROWD_PROPERTY_" + propertyName.toUpperCase(Locale.ENGLISH).replace(".", "_");
            return System.getenv(envPropertyName);
        }
        return null;
    }

    protected String loadAndLogPropertyString(Properties properties, String propertyName) {
        String propertyValue = ClientPropertiesImpl.loadPropertyString(properties, propertyName);
        if (propertyValue != null) {
            this.logger.info((Object)("Loading property: '" + propertyName + "' : '" + propertyValue + "'"));
        } else {
            this.logger.info((Object)("Failed to find value for property: " + propertyName));
        }
        return propertyValue;
    }

    private String loadBaseURL(Properties properties) {
        String baseURL = ClientPropertiesImpl.loadPropertyString(properties, "crowd.base.url");
        if (StringUtils.isBlank((String)baseURL)) {
            baseURL = this.generateBaseURL(properties);
        }
        return StringUtils.removeEnd((String)baseURL, (String)"/");
    }

    private String generateBaseURL(Properties properties) {
        String url = ClientPropertiesImpl.loadPropertyString(properties, "crowd.server.url");
        int firstSlash = StringUtils.lastIndexOf((String)url, (String)"/services");
        if (firstSlash != -1) {
            url = url.substring(0, firstSlash);
        }
        return url;
    }

    public static ClientPropertiesImpl newInstanceFromResourceLocator(ResourceLocator resourceLocator) {
        Properties properties = resourceLocator.getProperties();
        return ClientPropertiesImpl.newInstanceFromProperties(properties);
    }

    public static ClientPropertiesImpl newInstanceFromProperties(Properties properties) {
        ClientPropertiesImpl clientProperties = new ClientPropertiesImpl();
        clientProperties.updateProperties(properties);
        return clientProperties;
    }
}

