package com.atlassian.crowd.model.application;

public enum AccessBasedSynchronizationFilterType {
    NO_FILTERING,
    USER_ONLY_FILTERING,
    USER_AND_GROUP_FILTERING;

    public static AccessBasedSynchronizationFilterType fromApplication(Application application) {
        if (application.isFilteringGroupsWithAccessEnabled()) {
            return USER_AND_GROUP_FILTERING;
        } else if (application.isFilteringUsersWithAccessEnabled()) {
            return USER_ONLY_FILTERING;
        } else {
            return NO_FILTERING;
        }
    }
}