package com.atlassian.crowd.model.group;

import javax.annotation.Nullable;

import com.atlassian.crowd.model.DirectoryEntity;

/**
 * Represents a group.
 */
public interface Group extends DirectoryEntity, Comparable<Group> {
    /**
     * @return the type of the group.
     */
    GroupType getType();

    /**
     * @return <code>true</code> if and only if the user is allowed to authenticate.
     */
    boolean isActive();

    /**
     * @return description of the group or <code>null</code> if there is no description.
     */
    String getDescription();

    /**
     * This will return <code>null</code> for directories which do not support external ids
     *
     * @return external id of the group or <code>null</code> it there is no external id
     */
    @Nullable
    String getExternalId();
}
