package com.atlassian.crowd.model.event;

import java.util.Objects;

import javax.annotation.Nullable;

public abstract class AbstractOperationEvent implements OperationEvent {
    private final Operation operation;

    private final Long directoryId;

    protected AbstractOperationEvent(Operation operation, @Nullable Long directoryId) {
        this.operation = operation;
        this.directoryId = directoryId;
    }

    public Operation getOperation() {
        return operation;
    }

    public Long getDirectoryId() {
        return directoryId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AbstractOperationEvent that = (AbstractOperationEvent) o;
        return operation == that.operation && Objects.equals(this.directoryId, that.directoryId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operation, directoryId);
    }
}
