package com.atlassian.crowd.model.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.google.common.base.Function;
import com.google.common.base.Predicate;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

/**
 * Utility class for {@link Application}
 *
 * @since v2.7
 */
public final class Applications {
    /**
     * A function that projects the application name
     * @deprecated Use {@link Application#getName()} instead. Since 3.4.0.
     */
    @Deprecated
    public static final Function<Application, String> NAME_FUNCTION = Application::getName;

    /**
     * A predicate that checks if the application is active
     * @deprecated Use {@link Application#isActive()} instead. Since 3.4.0.
     */
    @Deprecated
    public static final Predicate<Application> ACTIVE_FILTER = Application::isActive;

    private Applications() {
        // I'm a utility class. Please use my static methods, but don't instantiate me
    }

    /**
     * Transforms applications into their names.
     *
     * @param applications some applications
     * @return their names
     */
    public static Iterable<String> namesOf(Iterable<? extends Application> applications) {
        return StreamSupport.stream(applications.spliterator(), false)
                .map(Application::getName)
                .collect(Collectors.toList());
    }

    /**
     * Given an {@code application}, retrieve all active directories associated with it.
     *
     * @param application application to query
     * @return list of active directories associated with {@code application}
     */
    public static List<Directory> getActiveDirectories(Application application) {
        return application.getApplicationDirectoryMappings().stream()
                .map(ApplicationDirectoryMapping::getDirectory)
                .filter(Directory::isActive)
                .collect(Collectors.toList());
    }
}
