package com.atlassian.crowd.util.build;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Build constants.
 */
public class BuildUtils {
    /**
     * Build Version.
     */
    public static final String BUILD_VERSION = "2.10.4";
    /**
     * Build Number.
     */
    public static final String BUILD_NUMBER = "688";
    /**
     * Build Date as String.
     */
    public static final String BUILD_DATE = "2018-07-10";
    private static final Logger log = LoggerFactory.getLogger(BuildUtils.class);
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    /**
     * Build Date as Date
     */
    private static Date parsedDate = null;

    /**
     * Build Version
     *
     * @return the current build version number.
     */
    public static String getVersion() {
        return new StringBuffer().append(BUILD_VERSION).append(" (Build:#").append(BUILD_NUMBER).append(" - ").append(BUILD_DATE).append(") ").toString();
    }

    public static Date getCurrentBuildDate() {
        if (parsedDate == null) {
            try {
                parsedDate = formatter.parse(BUILD_DATE);
            } catch (ParseException e) {
                log.error("Cannot Parse date: " + BUILD_DATE + ".  Returning null for date");
            }
        }

        return parsedDate;
    }

    public static int getCurrentBuildYear() {
        return Integer.parseInt(BUILD_DATE.substring(0, 4));
    }
}
