/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.builder;

import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Restriction {
    public static <T> RestrictionWithProperty<T> on(Property<T> propertyName) {
        return new RestrictionWithProperty<T>(propertyName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestrictionWithProperty<T> {
        private final Property<T> property;

        public RestrictionWithProperty(Property<T> property) {
            this.property = property;
        }

        public PropertyRestriction<T> exactlyMatching(T value) {
            return new TermRestriction<T>(this.property, MatchMode.EXACTLY_MATCHES, value);
        }

        public PropertyRestriction<T> startingWith(T value) {
            return new TermRestriction<T>(this.property, MatchMode.STARTS_WITH, value);
        }

        public PropertyRestriction<T> containing(T value) {
            return new TermRestriction<T>(this.property, MatchMode.CONTAINS, value);
        }

        public PropertyRestriction<T> lessThan(T value) {
            return new TermRestriction<T>(this.property, MatchMode.LESS_THAN, value);
        }

        public PropertyRestriction<T> greaterThan(T value) {
            return new TermRestriction<T>(this.property, MatchMode.GREATER_THAN, value);
        }

        public PropertyRestriction<T> isNull() {
            return new TermRestriction<Object>(this.property, MatchMode.NULL, null);
        }
    }
}

