/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.GroupMapping;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryMapping
implements Serializable {
    private Long id;
    private Application application;
    private Directory directory;
    private boolean allowAllToAuthenticate;
    private Set<GroupMapping> authorisedGroups = new HashSet<GroupMapping>();
    private Set<OperationType> allowedOperations = new HashSet<OperationType>();

    protected DirectoryMapping() {
    }

    public DirectoryMapping(Long id, Application application, Directory directory, boolean allowAllToAuthenticate) {
        this(application, directory, allowAllToAuthenticate);
        this.id = id;
    }

    public DirectoryMapping(Application application, Directory directory, boolean allowAllToAuthenticate) {
        this.application = application;
        this.directory = directory;
        this.allowAllToAuthenticate = allowAllToAuthenticate;
    }

    public DirectoryMapping(Application application, Directory directory, boolean allowAllToAuthenticate, Set<OperationType> allowedOperations) {
        this(application, directory, allowAllToAuthenticate);
        this.allowedOperations.addAll(allowedOperations);
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public Application getApplication() {
        return this.application;
    }

    private void setApplication(Application application) {
        this.application = application;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    private void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public boolean isAllowAllToAuthenticate() {
        return this.allowAllToAuthenticate;
    }

    public void setAllowAllToAuthenticate(boolean allowAllToAuthenticate) {
        this.allowAllToAuthenticate = allowAllToAuthenticate;
    }

    public Set<GroupMapping> getAuthorisedGroups() {
        return this.authorisedGroups;
    }

    private void setAuthorisedGroups(Set<GroupMapping> authorisedGroups) {
        this.authorisedGroups = authorisedGroups;
    }

    public boolean isAuthorised(String groupName) {
        for (GroupMapping mapping : this.getAuthorisedGroups()) {
            if (!mapping.getGroupName().equals(groupName)) continue;
            return true;
        }
        return false;
    }

    public void addGroupMapping(String groupName) {
        this.authorisedGroups.add(new GroupMapping(this, groupName));
    }

    public void removeGroupMapping(String groupName) {
        this.authorisedGroups.remove(new GroupMapping(this, groupName));
    }

    public void addAllowedOperations(OperationType ... operationTypes) {
        this.allowedOperations.addAll(Arrays.asList(operationTypes));
    }

    public void addAllowedOperation(OperationType operationType) {
        this.allowedOperations.add(operationType);
    }

    public Set<OperationType> getAllowedOperations() {
        return this.allowedOperations;
    }

    public void setAllowedOperations(Set<OperationType> allowedOperations) {
        this.allowedOperations = allowedOperations;
    }

    public boolean isAllowed(OperationType operation) {
        return this.allowedOperations.contains(operation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryMapping)) {
            return false;
        }
        DirectoryMapping that = (DirectoryMapping)o;
        if (this.getApplication() != null && this.getApplication().getId() != null ? !this.getApplication().getId().equals(that.getApplication().getId()) : that.getApplication() != null && that.getApplication().getId() != null) {
            return false;
        }
        return !(this.getDirectory() != null ? !this.getDirectory().getId().equals(that.getDirectory().getId()) : that.getDirectory() != null);
    }

    public int hashCode() {
        int result = this.getApplication() != null && this.getApplication().getId() != null ? this.getApplication().getId().hashCode() : 0;
        result = 31 * result + (this.getDirectory() != null ? this.getDirectory().getId().hashCode() : 0);
        return result;
    }
}

