/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.permission;

import com.atlassian.crowd.model.permission.ProductPermission;
import java.util.Objects;

public class ImmutableProductPermission
implements ProductPermission {
    private final String billingKey;
    private final ProductPermission.PermissionType type;
    private final String groupName;
    private final boolean isDefault;

    public ImmutableProductPermission(String billingKey, ProductPermission.PermissionType type, String groupName, boolean isDefault) {
        this.billingKey = Objects.requireNonNull(billingKey, "billingKey");
        this.type = Objects.requireNonNull(type, "type");
        this.groupName = Objects.requireNonNull(groupName, "groupName");
        if (!type.isDefaultSupported() && isDefault) {
            throw new IllegalArgumentException("isDefault must be false when type " + (Object)((Object)type));
        }
        this.isDefault = isDefault;
    }

    @Override
    public String getBillingKey() {
        return this.billingKey;
    }

    @Override
    public ProductPermission.PermissionType getType() {
        return this.type;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public boolean equals(Object o) {
        return ProductPermission.equal(this, o);
    }

    @Override
    public int hashCode() {
        return ProductPermission.hash(this);
    }

    public String toString() {
        return "ImmutableProductPermission{billingKey='" + this.billingKey + '\'' + ", type=" + (Object)((Object)this.type) + ", groupName='" + this.groupName + '\'' + ", isDefault=" + this.isDefault + '}';
    }
}

