package com.atlassian.crowd.support;

import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.google.common.collect.Ordering;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Builds a support information map from a bunch of fields.
 */
public final class SupportInformationBuilder {
    private final Map<String, String> map = new LinkedHashMap<>();

    private String prefix = "";

    /**
     * @deprecated use {@link SupportInformationBuilder#field(String, Object)} instead. Since 3.4.
     */
    @Deprecated
    public void addField(String name, Object value) {
        field(name, value);
    }

    public SupportInformationBuilder field(String name, Object value) {
        map.put(prefix + "." + name, value == null ? "null" : value.toString());
        return this;
    }

    /**
     * @deprecated use {@link SupportInformationBuilder#attributes(String, Map)} instead. Since 3.4.
     */
    @Deprecated
    public void addAttributes(String name, Map<String, String> attributesToSet) {
        attributes(name, attributesToSet);
    }

    public SupportInformationBuilder attributes(String name, Map<String, String> attributes) {
        for (String key : Ordering.natural().sortedCopy(attributes.keySet())) {
            map.put(prefix + "." + name + "." + key,
                    DirectoryImpl.PASSWORD_ATTRIBUTES.contains(key) ?
                            DirectoryImpl.SANITISED_PASSWORD : attributes.get(key));
        }
        return this;
    }

    public Map<String, String> getMap() {
        return map;
    }

    /**
     * @deprecated use {@link SupportInformationBuilder#prefix(String)} instead. Since 3.4.
     */
    @Deprecated
    public void setPrefix(String prefixToSet) {
        prefix(prefixToSet);
    }

    public SupportInformationBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}
