package com.atlassian.crowd.model.sso;

/**
 * Represents SAML SSO configuration for an application, without application data
 * @since 3.4.0
 */
public interface BaseApplicationSamlConfiguration {
    /**
     * @return the audience that will be used when creating assertions for the application
     */
    String getAudienceUrl();

    /**
     * @return the URL to which the assertion should be returned
     */
    String getAssertionConsumerUrl();

    /**
     * Returns NameID format configured for a given app. This format will be used in SAML Response from Crowd.
     * <p>
     * Note that if Authn Request contains NameIDPolicy with specified Format attribute, then format from Authn Request
     * has higher priority than NameID format from app config.
     *
     * @return NameID format configured for a given app
     * @since 4.4.0
     */
    NameIdFormat getNameIdFormat();

    /**
     * @return
     * @since 4.4.0
     */
    boolean isAddUserAttributesEnabled();
}
