package com.atlassian.crowd.manager.sso;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;

import java.util.Map;
import java.util.Objects;

public class InvalidGlobalSamlConfigurationException extends Exception {
    public enum Field {
        CERTIFICATE
    }

    public enum ErrorCode {
        INVALID
    }

    private final Map<Field, ErrorCode> errors;


// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    public InvalidGlobalSamlConfigurationException(Map<Field, ErrorCode> errors) {
        this.errors = ImmutableMap.copyOf(errors);
    }

    public Map<Field, ErrorCode> getErrors() {
        return errors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        InvalidGlobalSamlConfigurationException that = (InvalidGlobalSamlConfigurationException) o;

        return Objects.equals(this.getErrors(), that.getErrors());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getErrors());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("errors", getErrors())
                .toString();
    }
}
