package com.atlassian.crowd.directory;

import com.atlassian.crowd.embedded.api.Directory;

/**
 * Contains properties for {@link com.atlassian.crowd.embedded.api.Directory}.
 *
 * @since v2.1
 */
public class DirectoryProperties {
    /**
     * Key to specify whether the db caching should be enabled.
     */
    public static final String CACHE_ENABLED = "com.atlassian.crowd.directory.sync.cache.enabled";

    private DirectoryProperties() {
    }

    // TODO: move it to Directory
    public static boolean cachesAllUsers(Directory directory) {
        return cachesUsers(directory, true);
    }

    // TODO: move it to Directory
    public static boolean cachesAnyUsers(Directory directory) {
        return cachesUsers(directory, false);
    }

    // TODO: move it to Directory
    private  static boolean cachesUsers(Directory directory, boolean fullyCached) {
        switch (directory.getType()) {
            case CUSTOM: // fallthrough intended
            case UNKNOWN:
                return false;
            case INTERNAL: // fallthrough intended
            case AZURE_AD:
                return true;
            case CROWD: // fallthrough intended
            case CONNECTOR:
                return Boolean.parseBoolean(directory.getAttributes().get(DirectoryProperties.CACHE_ENABLED));
            case DELEGATING:
                return !fullyCached; // has only some users cached
            default:
                return false;
        }
    }
}
