package com.atlassian.crowd.search.query.membership;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;

import static com.atlassian.crowd.search.query.QueryUtils.checkAssignableFrom;

public class UserMembersOfGroupQuery<T> extends MembershipQuery<T> {
    /**
     * @deprecated Use {@link #UserMembersOfGroupQuery(Class, boolean, EntityDescriptor, EntityDescriptor, int, int, SearchRestriction, String...)} instead. Since v2.9.
     */
    @Deprecated
    public UserMembersOfGroupQuery(Class<T> returnType, boolean findMembers, EntityDescriptor entityToMatch, String entityNameToMatch, EntityDescriptor entityToReturn, int startIndex, int maxResults) {
        this(returnType, findMembers, entityToMatch, entityToReturn, startIndex, maxResults, QueryBuilder.NULL_RESTRICTION, entityNameToMatch);
    }

    public UserMembersOfGroupQuery(Class<T> returnType, boolean findMembers, EntityDescriptor entityToMatch, EntityDescriptor entityToReturn, int startIndex, int maxResults, SearchRestriction searchRestriction, String... entityNamesToMatch) {
        super(checkAssignableFrom(returnType, String.class, User.class), findMembers, entityToMatch, entityToReturn, startIndex, maxResults, searchRestriction, entityNamesToMatch);
    }
}
