package com.atlassian.crowd.model.token;

import java.util.Date;

public interface AuthenticationToken {

    long APPLICATION_TOKEN_DIRECTORY_ID = -1;

    Long getId();
    String getRandomHash();
    String getName();
    String getUnaliasedUsername();
    long getDirectoryId();
    long getRandomNumber();
    default boolean isUserToken() {
        return !isApplicationToken();
    }
    default boolean isApplicationToken() {
        return getDirectoryId() == APPLICATION_TOKEN_DIRECTORY_ID;
    }
    Date getCreatedDate();
    long getLastAccessedTime();
    TokenLifetime getLifetime();
    String getIdentifierHash();
}
