package com.atlassian.crowd.model.directory;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.embedded.api.Directory;

import javax.annotation.Nullable;

/**
 * Represents information about synchronisation status.
 *
 * @since 2.12.0
 */
public interface DirectorySynchronisationStatus {
    /**
     * Returns the Id of the DirectorySynchronisationStatus.
     *
     * @return id
     */
    Integer getId();

    /**
     * Returns synchronising directory.
     *
     * @return synchronising directory
     */
    Directory getDirectory();

    /**
     * Returns timestamp of the synchronisation's beginning.
     *
     * @return timestamp of of the start of the synchronisation
     */
    long getStartTimestamp();

    /**
     * Returns timestamp of the synchronisation's ending.
     *
     * @return timestamp of the end of the synchronisation, or {@code null} is synchronisation hasn't ended yet
     */
    @Nullable
    Long getEndTimestamp();

    /**
     * Returns status key of the synchronisation.
     *
     * @return status key of the synchronisation
     */
    SynchronisationStatusKey getStatus();

    /**
     * Returns parameters for the status key.
     *
     * @return parameters for the status k
     */
    String getStatusParameters();

    /**
     * Returns the incremental synchronisation failure reason.
     *
     * @return failure reason or null
     */
    @ExperimentalApi
    String getIncrementalSyncError();

    /**
     * Returns the full synchronisation failure reason.
     *
     * @return failure reason or null
     */
    @ExperimentalApi
    String getFullSyncError();

    /**
     * Returns id of the node performing the synchronisation.
     *
     * @return id of the node performing the synchronisation
     */
    String getNodeId();

    /**
     * Returns name of the node performing the synchronisation
     *
     * @return name of the node performing the synchronisation
     */
    @ExperimentalApi
    String getNodeName();
}
