package com.atlassian.crowd.audit;

import com.google.common.base.MoreObjects;

import java.util.Objects;

/**
 * Concrete implementation of an audit log author
 */
public class ImmutableAuditLogAuthor implements AuditLogAuthor {
    private final Long id;
    private final String name;
    private final AuditLogAuthorType type;

    public ImmutableAuditLogAuthor(Long id, String name, AuditLogAuthorType type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    public ImmutableAuditLogAuthor(AuditLogAuthor author) {
        this(author.getId(), author.getName(), author.getType());
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public AuditLogAuthorType getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImmutableAuditLogAuthor that = (ImmutableAuditLogAuthor) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(name, that.name) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, type);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("name", name)
                .add("type", type)
                .toString();
    }
}
