package com.atlassian.crowd.audit;

import javax.annotation.Nullable;

/**
 * Represents an audit log entry, belonging to a changeset
 */
public interface AuditLogEntry {

    /**
     * @return the name of the property that was modified in the event represented by this audit log entry
     */
    String getPropertyName();

    /**
     * @return the string representation of the modified property before modification
     */
    @Nullable
    String getOldValue();

    /**
     * @return the string representation of the modified property after modification
     */
    @Nullable
    String getNewValue();

}
