package com.atlassian.crowd.audit;

import javax.annotation.Nullable;

/**
 * Represents the author of an audit log entry
 */
public interface AuditLogAuthor {

    /**
     * @return the identifier of the author of the audit log entry (exact semantic depends on the author type)
     */
    @Nullable
    Long getId();

    /**
     * Returns the name of the author of the audit log entry. This is particularly useful when the author does not
     * exist anymore
     *
     * @return the name of the author of the audit log entry
     */
    @Nullable
    String getName();

    /**
     * @return information about the type of the event represented by this audit log entry
     */
    AuditLogAuthorType getType();
}
