package com.atlassian.crowd.manager.property;

import java.util.Optional;

public interface EncryptionSettings {
    /**
     * Returns name of the default encryptor or {@link Optional#empty()} if encryption is disabled.
     */
    Optional<String> getDefaultEncryptor();

    /**
     * Sets the name of the default encryptor.
     * @param name name of the default encryptor; {@code null} disables encryption
     */
    void setDefaultEncryptor(String name);

    /**
     * Sets encryption key path for specified encryptor
     */
    void setEncryptionKeyPath(String encryptor, String keyPath);

    /**
     * Gets encryption key path for specified encryptor if present.
     */
    Optional<String> getEncryptionKeyPath(String encryptor);

    /**
     * Returns path of the directory that stores encryption keys.
     */
    String getKeyFilesDirectoryPath();
}
