/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import java.util.ArrayList;
import java.util.Collection;

public class BulkAddResult<T> {
    private final Collection<T> failedEntities = new ArrayList<T>();
    private final Collection<T> existingEntities = new ArrayList<T>();
    private final long attemptedToAdd;
    private final boolean overwriteUsed;

    public BulkAddResult(long attemptingToAdd, boolean overwrite) {
        this.attemptedToAdd = attemptingToAdd;
        this.overwriteUsed = overwrite;
    }

    public void addFailedEntities(Collection<T> entities) {
        this.failedEntities.addAll(entities);
    }

    public void addFailedEntity(T entity) {
        this.failedEntities.add(entity);
    }

    public void addExistingEntity(T entity) {
        this.existingEntities.add(entity);
    }

    public Collection<T> getFailedEntities() {
        return this.failedEntities;
    }

    public Collection<T> getExistingEntities() {
        return this.existingEntities;
    }

    public boolean isOverwriteUsed() {
        return this.overwriteUsed;
    }

    public long getAttemptedToAdd() {
        return this.attemptedToAdd;
    }

    public long getAddedSuccessfully() {
        return this.attemptedToAdd - (long)this.failedEntities.size() - (long)this.existingEntities.size();
    }
}

