/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.directory;

import com.atlassian.crowd.integration.directory.RemoteDirectory;
import com.atlassian.crowd.integration.exception.DirectoryInstantiationException;
import com.atlassian.crowd.integration.model.AttributeAware;
import com.atlassian.crowd.integration.model.InternalEntity;
import com.atlassian.crowd.integration.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryInstanceLoader;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.crowd.model.directory.OperationType;
import com.atlassian.spring.container.ContainerManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Directory
extends InternalEntity
implements AttributeAware {
    public static final String ATTRIBUTE_KEY_USE_CACHING = "useCaching";
    public static final String ATTRIBUTE_KEY_USE_MONITORING = "useMonitoring";
    public static final String ATTRIBUTE_KEY_CACHE_CLASS = "cacheClass";
    public static final String ATTRIBUTE_KEY_CACHE_MAX_ELEMENTS_IN_MEMORY = "cacheMaxElements";
    public static final String ATTRIBUTE_KEY_POLLING_INTERVAL = "pollingInterval";
    public static final String ATTRIBUTE_KEY_USER_ENCRYPTION_METHOD = "user_encryption_method";
    public static final String ATTRIBUTE_KEY_USE_NESTED_GROUPS = "useNestedGroups";
    public static final String ATTRIBUTE_KEY_AUTO_ADD_GROUPS = "autoAddGroups";
    private String lowerName;
    private String description;
    private DirectoryType type;
    private String implementationClass;
    private String lowerImplementationClass;
    private Set<OperationType> allowedOperations = new HashSet<OperationType>();
    private Map<String, String> attributes = new HashMap<String, String>();

    public Directory() {
    }

    public Directory(InternalEntityTemplate template) {
        super(template);
    }

    public Directory(String name, DirectoryType type, String implementationClass) {
        this.setName(name);
        this.type = type;
        this.implementationClass = implementationClass;
        this.lowerImplementationClass = implementationClass.toLowerCase();
        this.active = true;
    }

    public RemoteDirectory getImplementation() throws DirectoryInstantiationException {
        return ((DirectoryInstanceLoader)ContainerManager.getComponent((String)"directoryInstanceLoader")).getDirectory(this);
    }

    public RemoteDirectory getRawImplementation() throws DirectoryInstantiationException {
        return ((DirectoryInstanceLoader)ContainerManager.getComponent((String)"directoryInstanceLoader")).getRawDirectory(this);
    }

    public String getEncryptionType() {
        String encryptionType = "com.atlassian.crowd.integration.directory.internal.InternalDirectory".equals(this.getImplementationClass()) ? this.getAttribute(ATTRIBUTE_KEY_USER_ENCRYPTION_METHOD) : this.getAttribute("ldap.user.encryption");
        return encryptionType;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Set<OperationType> getAllowedOperations() {
        return this.allowedOperations;
    }

    public void addAllowedOperation(OperationType operationType) {
        this.getAllowedOperations().add(operationType);
    }

    public void setAllowedOperations(Set<OperationType> allowedOperations) {
        this.allowedOperations = allowedOperations;
    }

    private void setLowerImplementationClass(String lowerImplementationClass) {
        this.lowerImplementationClass = lowerImplementationClass;
    }

    public String getLowerImplementationClass() {
        return this.lowerImplementationClass;
    }

    public String getLowerName() {
        return this.lowerName;
    }

    private void setLowerName(String lowerName) {
        this.lowerName = lowerName;
    }

    public String getDescription() {
        return this.description;
    }

    public DirectoryType getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return this.type.toString();
    }

    public String getImplementationClass() {
        return this.implementationClass;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(DirectoryType type) {
        this.type = type;
    }

    public void setImplementationClass(String implementationClass) {
        this.implementationClass = implementationClass;
        this.lowerImplementationClass = implementationClass.toLowerCase();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.lowerName = name.toLowerCase();
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public List<String> getAttributes(String name) {
        String value = this.getAttribute(name);
        if (value != null) {
            return Arrays.asList(value);
        }
        return null;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void validate() {
        Validate.notNull((Object)this.name, (String)"name cannot be null");
        Validate.isTrue((boolean)this.name.toLowerCase().equals(this.lowerName), (String)"lowerName must be the lower-case representation of name");
        Validate.notNull((Object)((Object)this.type), (String)"type cannot be null");
        Validate.notNull((Object)this.implementationClass, (String)"implementationClass cannot be null");
        Validate.notNull((Object)this.createdDate, (String)"createdDate cannot be null");
        Validate.notNull((Object)this.updatedDate, (String)"updatedDate cannot be null");
        Validate.notNull(this.allowedOperations, (String)"allowedOperations cannot be null");
        Validate.notNull(this.attributes, (String)"attributes cannot be null");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Directory)) {
            return false;
        }
        Directory that = (Directory)o;
        return !(this.getLowerName() != null ? !this.getLowerName().equals(that.getLowerName()) : that.getLowerName() != null);
    }

    @Override
    public int hashCode() {
        return this.getLowerName() != null ? this.getLowerName().hashCode() : 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("lowerName", (Object)this.getLowerName()).append("description", (Object)this.getDescription()).append("type", (Object)this.getType()).append("implementationClass", (Object)this.getImplementationClass()).append("allowedOperations", this.getAllowedOperations()).append("attributes", this.getAttributes()).toString();
    }
}

