/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model.user;

import com.atlassian.crowd.integration.model.LDAPDirectoryEntity;
import com.atlassian.crowd.integration.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPUserWithAttributes
implements UserWithAttributes,
LDAPDirectoryEntity {
    private final String dn;
    private final Long directoryId;
    private final String name;
    private final boolean active;
    private final String emailAddress;
    private final String firstName;
    private final String lastName;
    private final String displayName;
    private final String iconLocation;
    private final Map<String, List<String>> attributes = new HashMap<String, List<String>>();

    public LDAPUserWithAttributes(String dn, UserTemplateWithAttributes user) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)dn));
        Validate.notNull((Object)user, (String)"user template cannot be null");
        Validate.notNull((Object)user.getDirectoryId(), (String)"directoryId cannot be null");
        Validate.notNull((Object)user.getName(), (String)"user name cannot be null");
        this.dn = dn;
        this.directoryId = user.getDirectoryId();
        this.name = user.getName();
        this.active = user.isActive();
        this.emailAddress = user.getEmailAddress();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.displayName = user.getDisplayName();
        this.iconLocation = user.getIconLocation();
        for (Map.Entry<String, List<String>> entry : user.getAttributes().entrySet()) {
            this.attributes.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
    }

    public String getDn() {
        return this.dn;
    }

    public Long getDirectoryId() {
        return this.directoryId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIconLocation() {
        return this.iconLocation;
    }

    public List<String> getAttributes(String name) {
        if (this.attributes.containsKey(name)) {
            return Collections.unmodifiableList(this.attributes.get(name));
        }
        return Collections.emptyList();
    }

    public String getAttribute(String name) {
        List<String> values = this.getAttributes(name);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LDAPUserWithAttributes)) {
            return false;
        }
        LDAPUserWithAttributes that = (LDAPUserWithAttributes)o;
        if (this.directoryId != null ? !this.directoryId.equals(that.directoryId) : that.directoryId != null) {
            return false;
        }
        return !(this.name != null ? !this.name.toLowerCase().equals(that.name.toLowerCase()) : that.name != null);
    }

    public int hashCode() {
        int result = this.directoryId != null ? this.directoryId.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.toLowerCase().hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("dn", (Object)this.dn).append("directoryId", (Object)this.directoryId).append("name", (Object)this.name).append("active", this.active).append("emailAddress", (Object)this.emailAddress).append("firstName", (Object)this.firstName).append("lastName", (Object)this.lastName).append("displayName", (Object)this.displayName).append("iconLocation", (Object)this.iconLocation).append("attributes", this.attributes).toString();
    }
}

