/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model.group;

import com.atlassian.crowd.integration.model.LDAPDirectoryEntity;
import com.atlassian.crowd.integration.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPGroupWithAttributes
implements GroupWithAttributes,
LDAPDirectoryEntity {
    private final String dn;
    private final String name;
    private final Long directoryId;
    private final GroupType type;
    private final boolean active;
    private final String description;
    private final Map<String, List<String>> attributes = new HashMap<String, List<String>>();

    public LDAPGroupWithAttributes(String dn, GroupTemplateWithAttributes group) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)dn));
        Validate.notNull((Object)group, (String)"group template cannot be null");
        Validate.notNull((Object)group.getDirectoryId(), (String)"directoryId cannot be null");
        Validate.notNull((Object)group.getName(), (String)"group name cannot be null");
        Validate.notNull((Object)group.getType(), (String)"group type cannot be null");
        this.dn = dn;
        this.directoryId = group.getDirectoryId();
        this.name = group.getName();
        this.active = group.isActive();
        this.type = group.getType();
        this.description = group.getDescription();
        for (Map.Entry<String, List<String>> entry : group.getAttributes().entrySet()) {
            this.attributes.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
    }

    public String getDn() {
        return this.dn;
    }

    public String getName() {
        return this.name;
    }

    public Long getDirectoryId() {
        return this.directoryId;
    }

    public GroupType getType() {
        return this.type;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAttributes(String name) {
        if (this.attributes.containsKey(name)) {
            return Collections.unmodifiableList(this.attributes.get(name));
        }
        return Collections.emptyList();
    }

    public String getAttribute(String name) {
        List<String> values = this.getAttributes(name);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LDAPGroupWithAttributes)) {
            return false;
        }
        LDAPGroupWithAttributes that = (LDAPGroupWithAttributes)o;
        if (this.directoryId != null ? !this.directoryId.equals(that.directoryId) : that.directoryId != null) {
            return false;
        }
        return !(this.name != null ? !this.name.toLowerCase().equals(that.name.toLowerCase()) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.toLowerCase().hashCode() : 0;
        result = 31 * result + (this.directoryId != null ? this.directoryId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("dn", (Object)this.dn).append("name", (Object)this.name).append("directoryId", (Object)this.directoryId).append("type", (Object)this.type).append("active", this.active).append("description", (Object)this.description).append("attributes", this.attributes).toString();
    }
}

