/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model;

import com.atlassian.crowd.integration.model.AttributeAware;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityWithAttributes
implements AttributeAware {
    private final Map<String, List<String>> attributes;

    public EntityWithAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public List<String> getAttributes(String name) {
        if (this.attributes.containsKey(name)) {
            return Collections.unmodifiableList(this.attributes.get(name));
        }
        return Collections.emptyList();
    }

    public String getAttribute(String name) {
        List<String> values = this.getAttributes(name);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("attributes", this.attributes).toString();
    }
}

