/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory;

import com.atlassian.crowd.integration.SearchContext;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidPrincipalException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidSearchTermException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.AttributeValues;
import com.atlassian.crowd.integration.model.RemoteGroup;
import com.atlassian.crowd.integration.model.RemotePrincipal;
import com.atlassian.crowd.integration.model.RemoteRole;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RemoteDirectory {
    public long getID();

    public void setID(long var1);

    public String getDirectoryType();

    public Map<String, AttributeValues> getAttributes();

    public void setAttributes(Map<String, AttributeValues> var1);

    public RemotePrincipal addPrincipal(RemotePrincipal var1) throws InvalidPrincipalException, ObjectNotFoundException, InvalidCredentialException;

    public RemoteGroup addGroup(RemoteGroup var1) throws InvalidGroupException, ObjectNotFoundException;

    public RemotePrincipal authenticate(String var1, PasswordCredential[] var2) throws RemoteException, InvalidPrincipalException, InactiveAccountException, InvalidAuthenticationException;

    public boolean isGroupMember(String var1, String var2) throws ObjectNotFoundException;

    public boolean isDirectGroupMember(String var1, String var2) throws ObjectNotFoundException;

    public List<RemoteGroup> searchGroups(SearchContext var1) throws InvalidSearchTermException, ObjectNotFoundException;

    public RemoteGroup findGroupByName(String var1, boolean var2) throws ObjectNotFoundException;

    public RemoteGroup findGroupByName(String var1) throws ObjectNotFoundException;

    public RemoteGroup updateGroup(RemoteGroup var1) throws ObjectNotFoundException;

    public void addGroupToGroup(String var1, String var2) throws ObjectNotFoundException, UnsupportedOperationException;

    public void removeGroupFromGroup(String var1, String var2) throws ObjectNotFoundException, UnsupportedOperationException;

    public List<RemotePrincipal> findAllGroupMembers(String var1) throws ObjectNotFoundException;

    public List<RemotePrincipal> findAllRoleMembers(String var1) throws ObjectNotFoundException;

    public List<RemoteRole> searchRoles(SearchContext var1) throws InvalidSearchTermException, ObjectNotFoundException;

    public RemoteRole findRoleByName(String var1) throws ObjectNotFoundException;

    public RemoteRole addRole(RemoteRole var1) throws InvalidRoleException, ObjectNotFoundException;

    public RemoteRole updateRole(RemoteRole var1) throws ObjectNotFoundException;

    public void removeGroup(String var1) throws ObjectNotFoundException;

    public void removeRole(String var1) throws ObjectNotFoundException;

    public List<RemotePrincipal> searchPrincipals(SearchContext var1) throws InvalidSearchTermException;

    public RemotePrincipal findPrincipalByName(String var1) throws ObjectNotFoundException;

    public RemotePrincipal updatePrincipal(RemotePrincipal var1) throws ObjectNotFoundException;

    public void addPrincipalToGroup(String var1, String var2) throws ObjectNotFoundException;

    public void removePrincipalFromGroup(String var1, String var2) throws ObjectNotFoundException;

    public void addPrincipalToRole(String var1, String var2) throws ObjectNotFoundException;

    public void removePrincipalFromRole(String var1, String var2) throws ObjectNotFoundException;

    public void removePrincipal(String var1) throws ObjectNotFoundException;

    public void updatePrincipalCredential(String var1, PasswordCredential var2) throws ObjectNotFoundException, InvalidCredentialException;

    public void testConnection() throws RemoteException;

    public boolean isRoleMember(String var1, String var2) throws ObjectNotFoundException;

    public List<RemoteGroup> findGroupMemberships(String var1) throws ObjectNotFoundException;

    public List<RemoteRole> findRoleMemberships(String var1) throws ObjectNotFoundException;

    public boolean supportsNestedGroups();
}

