/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.util;

import com.atlassian.connect.play.java.util.ClassLoaderResourceLoader;
import com.atlassian.connect.play.java.util.PropertiesLoader;
import com.atlassian.connect.play.java.util.ResourceLoader;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
final class ResourcePropertiesLoader
implements PropertiesLoader {
    private final String resource;
    private final ResourceLoader loader;

    public ResourcePropertiesLoader(String resource) {
        this(resource, new ClassLoaderResourceLoader(ResourcePropertiesLoader.class));
    }

    public ResourcePropertiesLoader(String resource, ResourceLoader loader) {
        this.resource = (String)Preconditions.checkNotNull((Object)resource);
        this.loader = (ResourceLoader)Preconditions.checkNotNull((Object)loader);
    }

    @Override
    public Map<String, String> load() {
        return (Map)this.loader.load(this.resource).fold(Suppliers.ofInstance(Collections.emptyMap()), (Function)new Function<InputStream, Map<String, String>>(){

            public Map<String, String> apply(InputStream input) {
                return ResourcePropertiesLoader.this.loadProperties(input);
            }
        });
    }

    private Map<String, String> loadProperties(InputStream input) {
        try {
            Properties props = new Properties();
            props.load(input);
            Map<String, String> map = this.toMap(props);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)input);
        }
    }

    private Map<String, String> toMap(Properties props) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Object, Object> p : props.entrySet()) {
            builder.put((Object)p.getKey().toString(), (Object)p.getValue().toString());
        }
        return builder.build();
    }
}

