/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.util;

import com.atlassian.connect.play.java.util.ClassResourceLoader;
import com.atlassian.connect.play.java.util.EnvironmentPropertiesLoader;
import com.atlassian.connect.play.java.util.PropertiesLoader;
import com.atlassian.connect.play.java.util.ResourcePropertiesLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class Environment {
    private static final Map<String, String> env = Environment.loadEnv((Iterable<PropertiesLoader>)ImmutableList.of((Object)new ResourcePropertiesLoader("/env.properties", new ClassResourceLoader(Environment.class)), (Object)new EnvironmentPropertiesLoader()));

    public static String getEnv(String name) {
        String val = Environment.getOptionalEnv(name, null);
        if (val == null) {
            throw new IllegalArgumentException("Missing environment variable: " + name);
        }
        return val;
    }

    public static String getOptionalEnv(String name, String def) {
        String val = env.get(name);
        if (val == null) {
            return def;
        }
        return val.replaceAll("\\\\n", "\n");
    }

    private static ImmutableMap<String, String> loadEnv(Iterable<PropertiesLoader> propertiesLoaders) {
        HashMap envBuilder = Maps.newHashMap();
        for (PropertiesLoader properties : propertiesLoaders) {
            envBuilder.putAll(properties.load());
        }
        return ImmutableMap.copyOf((Map)envBuilder);
    }
}

