/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.upm;

import akka.actor.Cancellable;
import com.atlassian.connect.play.java.util.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.ning.http.client.Realm;
import java.util.concurrent.TimeUnit;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Akka;
import play.libs.F;
import play.libs.WS;
import scala.concurrent.duration.Duration;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class UpmClient {
    private static final String UPM_REST_PATH = "/rest/plugins/1.0";
    private final String baseUrl;

    public UpmClient(String baseUrl) {
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl);
    }

    public F.Promise<String> getToken() {
        return this.url("/").head().map((F.Function)new F.Function<WS.Response, String>(){

            public String apply(WS.Response response) throws Throwable {
                String token = response.getHeader("upm-token");
                Utils.LOGGER.trace("UPM token is " + token);
                return token;
            }
        });
    }

    public F.Promise<Boolean> install(final String uri, final F.Function<Boolean, F.Promise<Boolean>> callback) {
        return this.getToken().flatMap((F.Function)new F.Function<String, F.Promise<Boolean>>(){

            public F.Promise<Boolean> apply(String token) throws Throwable {
                return UpmClient.this.url("/").setQueryParameter("token", token).setHeader("Content-Type", "application/vnd.atl.plugins.remote.install+json").post("{ \"pluginUri\": \"" + uri + "\" }").flatMap((F.Function)new F.Function<WS.Response, F.Promise<Boolean>>(){

                    public F.Promise<Boolean> apply(WS.Response response) throws Throwable {
                        if (UpmClient.this.is2xxResponse(response)) {
                            UpmClient.this.checkInstallStatus(InstallStatus.fromResponse(response), (F.Function<Boolean, F.Promise<Boolean>>)callback);
                            return F.Promise.pure((Object)true);
                        }
                        Utils.LOGGER.debug(String.format("Could not install plugin (%s) to '%s' via UPM", uri, UpmClient.this.baseUrl));
                        Utils.LOGGER.debug(String.format("UPM responded with status code %s (%s) and the following message:\n%s", response.getStatus(), response.getStatusText(), response.getBody()));
                        return (F.Promise)callback.apply((Object)false);
                    }
                }).recover((F.Function)new F.Function<Throwable, Boolean>(){

                    public Boolean apply(Throwable throwable) throws Throwable {
                        Utils.LOGGER.error(String.format("An error occurred installing plugin (%s) to '%s' via UPM", uri, UpmClient.this.baseUrl), throwable);
                        return false;
                    }
                });
            }
        });
    }

    private F.Promise<InstallStatus> checkInstallStatus(String id, final F.Function<Boolean, F.Promise<Boolean>> callback) {
        return this.url(String.format("/pending/%s", id)).get().map((F.Function)new F.Function<WS.Response, InstallStatus>(){

            public InstallStatus apply(WS.Response response) throws Throwable {
                if (UpmClient.this.is2xxResponse(response)) {
                    return InstallStatus.fromResponse(response);
                }
                if (response.getStatus() == 303) {
                    Utils.LOGGER.info(String.format("Plugin successfully installed on %s (using the UPM REST end point).", UpmClient.this.baseUrl));
                    callback.apply((Object)true);
                    return InstallStatus.of(true, false);
                }
                Utils.LOGGER.error(String.format("Could not check status of plugin install! UPM responded with %s (%s) and the following message:\n:%s", response.getStatus(), response.getStatusText(), response.getBody()));
                callback.apply((Object)false);
                return InstallStatus.of(true, true);
            }
        }).recover((F.Function)new F.Function<Throwable, InstallStatus>(){

            public InstallStatus apply(Throwable throwable) throws Throwable {
                Utils.LOGGER.error("An error occurred checking the status of a plugin install", throwable);
                callback.apply((Object)false);
                return InstallStatus.of(true, true);
            }
        });
    }

    private void checkInstallStatus(final InstallStatus status, final F.Function<Boolean, F.Promise<Boolean>> callback) {
        if (!status.done && status.ping > 0) {
            Utils.LOGGER.trace("Checking the status...");
            this.scheduleOnce(status.ping, new Runnable(){

                @Override
                public void run() {
                    UpmClient.this.checkInstallStatus(status.id, (F.Function<Boolean, F.Promise<Boolean>>)callback).onRedeem((F.Callback)new F.Callback<InstallStatus>(){

                        public void invoke(InstallStatus installStatus) throws Throwable {
                            UpmClient.this.checkInstallStatus(installStatus, (F.Function<Boolean, F.Promise<Boolean>>)callback);
                        }
                    });
                }
            });
        }
    }

    private Cancellable scheduleOnce(int ping, Runnable runnable) {
        return Akka.system().scheduler().scheduleOnce(Duration.create((long)ping, (TimeUnit)TimeUnit.MILLISECONDS), runnable, Akka.system().dispatcher());
    }

    private boolean is2xxResponse(WS.Response response) {
        int status = response.getStatus();
        return 200 <= status && status < 300;
    }

    private WS.WSRequestHolder url(String path) {
        return WS.url((String)this.absoluteUrl(path)).setFollowRedirects(Boolean.valueOf(false)).setAuth("admin", "admin", Realm.AuthScheme.BASIC);
    }

    private String absoluteUrl(String path) {
        return this.baseUrl + UPM_REST_PATH + path;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static final class InstallStatus {
        public final String id;
        public final boolean done;
        public final int ping;
        public final boolean error;

        private InstallStatus(String id, boolean done, int ping, boolean error2) {
            this.id = id;
            this.done = done;
            this.ping = ping;
            this.error = error2;
        }

        static InstallStatus of(boolean done, boolean error2) {
            return new InstallStatus(null, done, 0, error2);
        }

        static InstallStatus fromResponse(WS.Response response) {
            JsonNode jsonNode = response.asJson();
            JsonNode statusNode = jsonNode.get("status");
            int ping = jsonNode.has("pingAfter") ? jsonNode.get("pingAfter").intValue() : 0;
            String self = jsonNode.get("links").get("self").textValue();
            String id = self.substring(self.lastIndexOf(47) + 1, self.length());
            boolean done = statusNode.get("done").booleanValue();
            if (done && statusNode.has("subCode")) {
                Utils.LOGGER.error("An error occurred installing this plugin: " + statusNode.get("subCode"));
            }
            return new InstallStatus(id, done, ping, false);
        }
    }
}

