/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.token;

import com.atlassian.connect.play.java.AC;
import com.atlassian.connect.play.java.token.CheckValidToken;
import com.atlassian.connect.play.java.token.Token;
import com.atlassian.fugue.Option;
import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.SimpleResult;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class PageTokenValidatorAction
extends Action<CheckValidToken> {
    public static final String HEADER_PREFIX = "X-";
    public static final String TOKEN_KEY = "acpt";

    public F.Promise<SimpleResult> call(Http.Context context) throws Throwable {
        boolean allowInsecurePolling = ((CheckValidToken)this.configuration).allowInsecurePolling();
        Option<String> token = this.extractTokenDetails(context.request());
        if (token.isEmpty()) {
            return F.Promise.pure((Object)PageTokenValidatorAction.unauthorized((String)"Unauthorised: It appears your session has expired. Please reload the page."));
        }
        Option<Token> decryptedToken = AC.validateToken((String)token.get(), allowInsecurePolling);
        if (decryptedToken.isEmpty()) {
            return F.Promise.pure((Object)PageTokenValidatorAction.unauthorized((String)"Unauthorised: It appears your session has expired. Please reload the page."));
        }
        AC.setAcHost(((Token)decryptedToken.get()).getAcHost());
        Option<String> user = ((Token)decryptedToken.get()).getUser();
        if (user.isDefined()) {
            context.args.put("user_id", user.get());
        }
        AC.refreshToken(allowInsecurePolling);
        if (allowInsecurePolling) {
            context.response().setHeader("X-acpt", (String)AC.getToken().get());
        }
        return this.delegate.call(context);
    }

    private Option<String> extractTokenDetails(Http.Request request) {
        String token = request.getHeader("X-acpt");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = request.getQueryString(TOKEN_KEY);
        }
        return Option.option((Object)token);
    }
}

