/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.service;

import com.atlassian.connect.play.java.service.AcHostHttpClientImpl;
import com.atlassian.connect.play.java.service.AcHostRepository;
import com.atlassian.connect.play.java.service.AcHostService;
import com.atlassian.connect.play.java.service.AcHostServiceImpl;
import com.atlassian.connect.play.java.service.DefaultAcHostRepository;
import com.atlassian.connect.play.java.util.Utils;
import org.apache.commons.lang.StringUtils;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class InjectorFactory {
    public static AcHostService getAcHostService() {
        String acHostServiceClass = Play.application().configuration().getString("ac.hostrepository");
        if (!StringUtils.isEmpty((String)acHostServiceClass)) {
            try {
                AcHostRepository repository = (AcHostRepository)Class.forName(acHostServiceClass, false, Play.application().classloader()).newInstance();
                return new AcHostServiceImpl(new AcHostHttpClientImpl(), repository);
            }
            catch (Exception e) {
                Utils.LOGGER.error("Could not load " + acHostServiceClass + " as the AC Host Repository", (Throwable)e);
                throw new IllegalStateException("No AC Host Repository available", e);
            }
        }
        return new AcHostServiceImpl(new AcHostHttpClientImpl(), new DefaultAcHostRepository());
    }
}

