/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.service;

import com.atlassian.connect.play.java.AcHost;
import com.atlassian.connect.play.java.auth.PublicKeyVerificationFailureException;
import com.atlassian.connect.play.java.service.AcHostHttpClient;
import com.atlassian.connect.play.java.service.AcHostRepository;
import com.atlassian.connect.play.java.service.AcHostService;
import com.atlassian.connect.play.java.service.DefaultAcHostRepository;
import com.atlassian.fugue.Option;
import com.google.common.base.Supplier;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.WS;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AcHostServiceImpl
implements AcHostService {
    private static final String PUBLIC_KEY_ELEMENT_NAME = "publicKey";
    private final AcHostHttpClient httpClient;
    private final AcHostRepository acHostRepository;

    public AcHostServiceImpl(AcHostHttpClient httpClient, AcHostRepository acHostRepository) {
        this.httpClient = httpClient;
        this.acHostRepository = acHostRepository;
    }

    public AcHostServiceImpl(AcHostHttpClient httpClient) {
        this(httpClient, new DefaultAcHostRepository());
    }

    @Override
    public F.Promise<String> fetchPublicKeyFromRemoteHost(AcHost acHost) {
        F.Promise responsePromise = this.httpClient.url(acHost.getConsumerInfoUrl(), acHost, false).get();
        F.Promise publicKeyPromise = responsePromise.map((F.Function)new F.Function<WS.Response, String>(){

            public String apply(WS.Response response) throws Throwable {
                Document consumerInfoDoc;
                NodeList publicKeyElements;
                if (response.getStatus() == 200 && (publicKeyElements = (consumerInfoDoc = response.asXml()).getElementsByTagName(AcHostServiceImpl.PUBLIC_KEY_ELEMENT_NAME)).getLength() == 1) {
                    return publicKeyElements.item(0).getTextContent();
                }
                throw new PublicKeyVerificationFailureException("Failed to fetch public key for verification. Response status: " + response.getStatus());
            }
        });
        return publicKeyPromise;
    }

    @Override
    public F.Promise<Void> registerHost(AcHost acHost) {
        return this.registerHost(acHost.getKey(), acHost.getBaseUrl(), acHost.getPublicKey(), acHost.getSharedSecret(), acHost.getName());
    }

    @Override
    public F.Promise<Void> registerHost(String clientKey, final String baseUrl, String publicKey, String sharedSecret, String name) {
        Option<AcHost> acHostOption;
        try {
            acHostOption = this.acHostRepository.findByKey(clientKey);
        }
        catch (Throwable throwable) {
            return F.Promise.throwing((Throwable)throwable);
        }
        AcHost acHost = (AcHost)acHostOption.orElse((Supplier)new Supplier<Option<AcHost>>(){

            public Option<AcHost> get() {
                try {
                    return AcHostServiceImpl.this.acHostRepository.findByUrl(baseUrl);
                }
                catch (Throwable e) {
                    return Option.none(AcHost.class);
                }
            }
        }).getOrElse((Object)new AcHost());
        acHost.setKey(clientKey);
        acHost.setBaseUrl(baseUrl);
        acHost.setPublicKey(publicKey);
        acHost.setSharedSecret(sharedSecret);
        acHost.setName(name);
        try {
            this.acHostRepository.save(acHost);
        }
        catch (Throwable throwable) {
            return F.Promise.throwing((Throwable)throwable);
        }
        return F.Promise.pure(null);
    }

    @Override
    public Option<AcHost> findByKey(String consumerKey) throws Throwable {
        return this.acHostRepository.findByKey(consumerKey);
    }

    @Override
    public List<AcHost> all() throws Throwable {
        return this.acHostRepository.all();
    }
}

