/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.plugin;

import com.atlassian.connect.play.java.AC;
import com.atlassian.connect.play.java.plugin.AbstractPlugin;
import com.atlassian.fugue.Option;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import play.Application;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class TokenPlugin
extends AbstractPlugin {
    private static final long DEFAULT_TOKEN_EXPIRY = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);

    public TokenPlugin(Application application) {
        super(application);
    }

    public void onStart() {
        AC.tokenExpiry = (Long)this.getConfiguredTokenExpiry().getOrElse((Object)DEFAULT_TOKEN_EXPIRY);
        super.onStart();
    }

    private Option<Long> getConfiguredTokenExpiry() {
        String tokenExpiry = this.application.configuration().getString("ac.token.expiry.secs");
        if (StringUtils.isNotBlank((CharSequence)tokenExpiry) && StringUtils.isNumeric((CharSequence)tokenExpiry)) {
            return Option.some((Object)TimeUnit.MILLISECONDS.convert(Long.parseLong(tokenExpiry), TimeUnit.SECONDS));
        }
        return Option.none();
    }
}

