/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.plugin;

import com.atlassian.connect.play.java.util.Utils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import javax.annotation.Nullable;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
final class IsApplicationListeningPredicate
implements Predicate<URI> {
    IsApplicationListeningPredicate() {
    }

    public boolean apply(@Nullable URI uri) {
        Preconditions.checkNotNull((Object)uri);
        Utils.LOGGER.debug(String.format("Scanning for application at '%s'", uri));
        return this.canOpenSocket(uri.getHost(), uri.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean canOpenSocket(String hostName, int port) {
        boolean bl;
        Socket socket = null;
        try {
            socket = new Socket(hostName, port);
            bl = true;
        }
        catch (UnknownHostException e) {
            Utils.LOGGER.warn(String.format("Could not resolve host name '%s'", hostName), (Throwable)e);
            boolean bl2 = false;
            Closeables.closeQuietly((Closeable)socket);
            return bl2;
        }
        catch (IOException e2) {
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    Closeables.closeQuietly(socket);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)socket);
            return bl3;
        }
        Closeables.closeQuietly((Closeable)socket);
        return bl;
    }
}

