/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.plugin;

import com.atlassian.connect.play.java.AC;
import com.atlassian.connect.play.java.BaseUrl;
import com.atlassian.connect.play.java.plugin.AbstractPlugin;
import com.atlassian.connect.play.java.util.Environment;
import com.atlassian.connect.play.java.util.Utils;
import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import play.Application;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class AcBaseUrlPlugin
extends AbstractPlugin {
    private static final String DEFAULT_BASE_URL = "http://localhost:9000";

    public AcBaseUrlPlugin(Application application) {
        super(application);
        AC.baseUrl = new ApplicationBaseUrl((Application)Preconditions.checkNotNull((Object)application));
        Utils.LOGGER.info(String.format("Resolved base URL of application as '%s'", AC.baseUrl.get()));
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static final class ApplicationBaseUrl
    implements BaseUrl {
        private final Application application;

        public ApplicationBaseUrl(Application application) {
            this.application = (Application)Preconditions.checkNotNull((Object)application);
        }

        public String get() {
            String baseUrl = (String)this.getBaseUrlFromEnv().getOrElse((Object)this.getBaseUrlFromConfiguration());
            return this.stripTrailingSlash(baseUrl);
        }

        private String stripTrailingSlash(String baseUrl) {
            if (baseUrl.endsWith("/")) {
                return baseUrl.substring(0, baseUrl.length() - 1);
            }
            return baseUrl;
        }

        private Option<String> getBaseUrlFromEnv() {
            return Option.option((Object)Environment.getOptionalEnv("BASE_URL", null));
        }

        private String getBaseUrlFromConfiguration() {
            return this.application.configuration().getString("application.baseUrl", AcBaseUrlPlugin.DEFAULT_BASE_URL);
        }
    }
}

