/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.plugin;

import com.atlassian.connect.play.java.AC;
import com.atlassian.connect.play.java.plugin.AbstractDevPlugin;
import com.atlassian.connect.play.java.plugin.IsApplicationListeningPredicate;
import com.atlassian.connect.play.java.upm.UpmClient;
import com.atlassian.connect.play.java.util.Utils;
import com.atlassian.fugue.Pair;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.List;
import java.util.Set;
import play.Application;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class AcAutoInstallPlugin
extends AbstractDevPlugin {
    private static final Set<URI> AUTOREGISTER_HOSTS = ImmutableSet.of((Object)URI.create("http://localhost:1990/confluence"), (Object)URI.create("http://localhost:2990/jira"), (Object)URI.create("http://localhost:5990/refapp"));

    public AcAutoInstallPlugin(Application application) {
        super(application);
    }

    public void onStart() {
        AcAutoInstallPlugin.install();
    }

    public static F.Promise<List<Pair<URI, Boolean>>> install() {
        Iterable listeningApplications = Iterables.filter(AUTOREGISTER_HOSTS, (Predicate)new IsApplicationListeningPredicate());
        final String playAppBaseUrl = (String)AC.baseUrl.get();
        return F.Promise.sequence((Iterable)Iterables.transform((Iterable)listeningApplications, (Function)new Function<URI, F.Promise<? extends Pair<URI, Boolean>>>(){

            public F.Promise<Pair<URI, Boolean>> apply(URI appUri) {
                return AcAutoInstallPlugin.install(appUri, playAppBaseUrl);
            }
        }));
    }

    private static F.Promise<Pair<URI, Boolean>> install(final URI appUri, final String playAppBaseUrl) {
        final String baseUrl = appUri.toString();
        Utils.LOGGER.info("Attempting to install addon with baseURL = " + playAppBaseUrl + " to application at url = " + baseUrl);
        return new UpmClient(baseUrl).install(playAppBaseUrl, new F.Function<Boolean, F.Promise<Boolean>>(){

            public F.Promise<Boolean> apply(Boolean installed) throws Throwable {
                Utils.LOGGER.info((installed != false ? "Succeeded" : "Failed") + " installing addon with baseURL = " + playAppBaseUrl + " to application at url = " + baseUrl);
                return F.Promise.pure((Object)installed);
            }
        }).map((F.Function)new F.Function<Boolean, Pair<URI, Boolean>>(){

            public Pair<URI, Boolean> apply(Boolean installed) throws Throwable {
                return Pair.pair((Object)appUri, (Object)installed);
            }
        });
    }
}

