/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.controllers;

import com.atlassian.connect.play.java.controllers.AcDocumentation;
import com.atlassian.connect.play.java.service.AcHostService;
import com.atlassian.connect.play.java.service.InjectorFactory;
import com.atlassian.connect.play.java.util.DescriptorUtils;
import com.atlassian.connect.play.java.util.Utils;
import com.atlassian.fugue.Option;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import controllers.AssetsBuilder;
import java.io.IOException;
import play.api.mvc.Action;
import play.api.mvc.AnyContent;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.BodyParser;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AcController {
    private static final String CLIENT_KEY = "clientKey";
    private static final String BASE_URL = "baseUrl";
    private static final String SHARED_SECRET = "sharedSecret";
    private static final String PRODUCT_TYPE = "productType";
    private static final String PUBLIC_KEY_ELEMENT_NAME = "publicKey";
    @VisibleForTesting
    public static AcHostService acHostService = InjectorFactory.getAcHostService();
    private static AssetsBuilder delegate = new AssetsBuilder();

    public static Result index() {
        return AcController.index(AcController.home(), AcController.descriptorSupplier());
    }

    public static Result index(Supplier<Result> home, Supplier<Result> descriptor2) {
        if (AcController.isRequestFromUpm()) {
            return (Result)descriptor2.get();
        }
        if (AcController.isAcceptHtml()) {
            return (Result)home.get();
        }
        if (AcController.isAcceptJson()) {
            return (Result)descriptor2.get();
        }
        throw new IllegalStateException("Why do we end up here!");
    }

    private static boolean isAcceptJson() {
        return Controller.request().accepts("application/json");
    }

    private static boolean isAcceptHtml() {
        return Controller.request().accepts("text/html");
    }

    private static boolean isRequestFromUpm() {
        return (Boolean)Option.option((Object)AcController.getPacClientInfoHeader()).fold(Suppliers.ofInstance((Object)Boolean.FALSE), (Function)new Function<String, Boolean>(){

            public Boolean apply(String input) {
                boolean isUpm = input.startsWith("client=upm");
                if (isUpm) {
                    Utils.LOGGER.debug(String.format("Upm is requesting the plugin descriptor: %s", input));
                }
                return isUpm;
            }
        });
    }

    private static String getPacClientInfoHeader() {
        return Controller.request().getHeader("X-Pac-Client-Info");
    }

    public static Result descriptor() {
        try {
            return Results.ok((String)DescriptorUtils.substituteVariablesInDefaultFile());
        }
        catch (IOException e) {
            Utils.LOGGER.error("Failed to create substituted descriptor", (Throwable)e);
            return Results.internalServerError((String)("Failed to create substituted descriptor: " + e.getMessage()));
        }
    }

    public static Supplier<Result> home() {
        return new Supplier<Result>(){

            public Result get() {
                return AcDocumentation.index();
            }
        };
    }

    public static Supplier<Result> descriptorSupplier() {
        return new Supplier<Result>(){

            public Result get() {
                return AcController.descriptor();
            }
        };
    }

    @BodyParser.Of(value=BodyParser.Json.class)
    public static F.Promise<Result> registration() {
        Utils.LOGGER.info("Registering host application!");
        final JsonNode remoteApp = Controller.request().body().asJson();
        if (remoteApp == null) {
            return F.Promise.pure((Object)Results.badRequest((String)"can't extract registration request json"));
        }
        String clientKey = AcController.getAttributeAsText(remoteApp, CLIENT_KEY);
        F.Promise<Void> hostRegistered = acHostService.registerHost(clientKey, AcController.getAttributeAsText(remoteApp, BASE_URL), AcController.getAttributeAsText(remoteApp, PUBLIC_KEY_ELEMENT_NAME), AcController.getAttributeAsText(remoteApp, SHARED_SECRET), AcController.getAttributeAsText(remoteApp, PRODUCT_TYPE));
        F.Promise resultPromise = hostRegistered.map((F.Function)new F.Function<Void, Result>(){

            public Result apply(Void nada) throws Throwable {
                return Results.ok();
            }
        });
        return resultPromise.recover((F.Function)new F.Function<Throwable, Result>(){

            public Result apply(Throwable throwable) throws Throwable {
                Utils.LOGGER.warn("Failed to register host: " + remoteApp.toString(), throwable);
                return Results.badRequest((String)"Unable to register host. Request invalid");
            }
        });
    }

    private static String getAttributeAsText(JsonNode json, String name) {
        JsonNode jsonNode = json.get(name);
        return jsonNode == null ? null : jsonNode.textValue();
    }

    public static Action<AnyContent> asset(String path, String file) {
        return delegate.at(path, file);
    }
}

