/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.auth.jwt;

import com.atlassian.connect.play.java.auth.jwt.JwtAuthenticationResult;
import com.atlassian.jwt.Jwt;
import com.atlassian.jwt.core.http.JwtRequestExtractor;
import com.atlassian.jwt.core.http.auth.AbstractJwtAuthenticator;
import com.atlassian.jwt.core.http.auth.AuthenticationResultHandler;
import com.atlassian.jwt.core.http.auth.SimplePrincipal;
import com.atlassian.jwt.exception.JwtIssuerLacksSharedSecretException;
import com.atlassian.jwt.exception.JwtParseException;
import com.atlassian.jwt.exception.JwtUnknownIssuerException;
import com.atlassian.jwt.exception.JwtUserRejectedException;
import com.atlassian.jwt.exception.JwtVerificationException;
import com.atlassian.jwt.reader.JwtClaimVerifier;
import com.atlassian.jwt.reader.JwtReaderFactory;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Map;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PlayJwtAuthenticator
extends AbstractJwtAuthenticator<Http.Request, Http.Response, JwtAuthenticationResult> {
    private final JwtReaderFactory jwtReaderFactory;

    public PlayJwtAuthenticator(JwtRequestExtractor<Http.Request> jwtExtractor, AuthenticationResultHandler<Http.Response, JwtAuthenticationResult> authenticationResultHandler, JwtReaderFactory jwtReaderFactory) {
        super(jwtExtractor, authenticationResultHandler);
        this.jwtReaderFactory = (JwtReaderFactory)PlayJwtAuthenticator.checkNotNull((Object)jwtReaderFactory);
    }

    protected Principal authenticate(Http.Request request, Jwt jwt) throws JwtUserRejectedException {
        return jwt.getSubject() == null ? null : new SimplePrincipal(jwt.getSubject());
    }

    protected Jwt verifyJwt(String jwt, Map<String, ? extends JwtClaimVerifier> claimVerifiers) throws JwtParseException, JwtVerificationException, JwtIssuerLacksSharedSecretException, JwtUnknownIssuerException, IOException, NoSuchAlgorithmException {
        return this.jwtReaderFactory.getReader(jwt).read(jwt, claimVerifiers);
    }
}

