/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.auth.jwt;

import com.atlassian.connect.play.java.AcHost;
import com.atlassian.connect.play.java.auth.jwt.JwtAuthorizationGenerator;
import com.atlassian.connect.play.java.util.Utils;
import com.atlassian.fugue.Option;
import com.atlassian.jwt.exception.JwtIssuerLacksSharedSecretException;
import com.atlassian.jwt.exception.JwtUnknownIssuerException;
import com.google.common.base.Preconditions;
import com.ning.http.client.FluentStringsMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.WS;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class JwtSignatureCalculator
implements WS.SignatureCalculator {
    private final JwtAuthorizationGenerator jwtAuthorizationGenerator;
    private final AcHost acHost;
    private final Option<String> userId;

    public JwtSignatureCalculator(JwtAuthorizationGenerator jwtAuthorizationGenerator, AcHost acHost, Option<String> userId) {
        this.jwtAuthorizationGenerator = (JwtAuthorizationGenerator)Preconditions.checkNotNull((Object)jwtAuthorizationGenerator);
        this.acHost = (AcHost)Preconditions.checkNotNull((Object)acHost);
        this.userId = userId;
    }

    public void sign(WS.WSRequest request) {
        String authorizationHeaderValue = this.getAuthorizationHeaderValue(request);
        Utils.LOGGER.debug(String.format("Generated Jwt authorisation header: '%s'", authorizationHeaderValue));
        request.setHeader("Authorization", authorizationHeaderValue);
    }

    public String getAuthorizationHeaderValue(WS.WSRequest request) throws IllegalArgumentException {
        try {
            Option<String> jwt = this.jwtAuthorizationGenerator.generate(request.getMethod(), request.getUrl(), (Map<String, List<String>>)this.getQueryParams(request), this.acHost, this.userId);
            return (String)jwt.getOrNull();
        }
        catch (JwtIssuerLacksSharedSecretException | JwtUnknownIssuerException e) {
            throw new IllegalArgumentException("Failed to sign the request", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private FluentStringsMap getQueryParams(WS.WSRequest request) {
        Object underlyingRequest = this.getRequestObject(this.getRequestField(request), request);
        return this.getQueryParams(this.getGetQueryParamsMethod(underlyingRequest), underlyingRequest);
    }

    private FluentStringsMap getQueryParams(Method m, Object request) {
        try {
            return (FluentStringsMap)m.invoke(request, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Method getGetQueryParamsMethod(Object o) {
        try {
            Method m = o.getClass().getMethod("getQueryParams", new Class[0]);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private Field getRequestField(WS.WSRequest request) {
        try {
            Field f2 = request.getClass().getSuperclass().getDeclaredField("request");
            f2.setAccessible(true);
            return f2;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getRequestObject(Field f2, WS.WSRequest request) {
        try {
            return f2.get(request);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

