/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java;

import com.google.common.annotations.VisibleForTesting;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import play.core.enhancers.PropertiesEnhancer;
import play.data.validation.Constraints;

@Entity
@Table(name="ac_host")
@NamedQueries(value={@NamedQuery(name="AcHost.findAll", query="SELECT a FROM AcHost a"), @NamedQuery(name="AcHost.findByKey", query="SELECT a FROM AcHost a where a.key = :key"), @NamedQuery(name="AcHost.findByUrl", query="SELECT a FROM AcHost a where a.baseUrl = :baseUrl")})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class AcHost {
    @VisibleForTesting
    public static final String CONSUMER_INFO_URL = "/plugins/servlet/oauth/consumer-info";
    @Id
    @SequenceGenerator(name="ac_host_gen", sequenceName="ac_host_seq")
    @GeneratedValue(generator="ac_host_gen")
    private Long id;
    @Constraints.Required
    @Column(unique=true, nullable=false)
    private String key;
    @Constraints.MaxLength(value=512L)
    @Column(length=512)
    public String publicKey;
    @Constraints.MaxLength(value=512L)
    @Column(length=512)
    public String sharedSecret;
    @Constraints.Required
    @Constraints.MaxLength(value=512L)
    @Column(unique=true, nullable=false, length=512)
    private String baseUrl;
    private String name;
    private String description;

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public String getConsumerInfoUrl() {
        return this.baseUrl + CONSUMER_INFO_URL;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setName(String name) {
        this.name = name;
    }
}

