/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java;

import com.atlassian.connect.play.java.AcHost;
import com.atlassian.connect.play.java.BaseUrl;
import com.atlassian.connect.play.java.auth.jwt.JwtAuthConfig;
import com.atlassian.connect.play.java.auth.jwt.JwtAuthorizationGenerator;
import com.atlassian.connect.play.java.auth.jwt.JwtSignatureCalculator;
import com.atlassian.connect.play.java.service.AcHostService;
import com.atlassian.connect.play.java.service.InjectorFactory;
import com.atlassian.connect.play.java.token.Token;
import com.atlassian.connect.play.java.util.Utils;
import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import play.Play;
import play.api.libs.Crypto;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;
import play.libs.WS;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class AC {
    private static final Long DEFAULT_TIMEOUT = TimeUnit.SECONDS.convert(5L, TimeUnit.MILLISECONDS);
    public static String PLUGIN_KEY = Play.application().configuration().getString("ac.key", AC.isDev() ? "_add-on_key" : null);
    public static String PLUGIN_NAME = (String)Option.option((Object)Play.application().configuration().getString("ac.name", AC.isDev() ? "Atlassian Connect Play Add-on" : null)).getOrElse((Object)PLUGIN_KEY);
    public static BaseUrl baseUrl;
    public static long tokenExpiry;
    private static final JwtAuthorizationGenerator jwtAuthorisationGenerator;
    private static final AcHostService acHostService;

    public static boolean isDev() {
        return Play.isDev() || Play.isTest() || Boolean.valueOf(Play.application().configuration().getString("ac.dev", "false")) != false || Boolean.getBoolean("ac.dev");
    }

    public static Option<String> getUser() {
        return Option.option((Object)((String)AC.getHttpContext().args.get("user_id")));
    }

    public static void setUser(String user) {
        AC.getHttpContext().args.put("user_id", user);
    }

    public static WS.WSRequestHolder url(String url) {
        return AC.url(url, (AcHost)Preconditions.checkNotNull((Object)AC.getAcHost(), (Object)"No AcHost found in HttpContext"));
    }

    public static WS.WSRequestHolder url(String url, AcHost acHost) {
        return AC.url(url, acHost, true);
    }

    public static WS.WSRequestHolder url(String url, AcHost acHost, boolean signRequest) {
        return AC.url(url, acHost, AC.getUser(), signRequest);
    }

    public static WS.WSRequestHolder url(String url, AcHost acHost, Option<String> userId) {
        return AC.url(url, acHost, userId, true);
    }

    public static WS.WSRequestHolder url(String url, AcHost acHost, Option<String> userId, boolean signRequest) {
        Preconditions.checkNotNull((Object)url, (Object)"Url must be non-null");
        Preconditions.checkNotNull((Object)acHost, (Object)"acHost must be non-null");
        String absoluteUrl = AC.getAbsoluteUrl(url, acHost);
        Utils.LOGGER.debug(String.format("Creating request to '%s'", absoluteUrl));
        WS.WSRequestHolder request = WS.url((String)absoluteUrl).setTimeout(DEFAULT_TIMEOUT.intValue());
        if (signRequest) {
            request.setFollowRedirects(Boolean.valueOf(false)).sign((WS.SignatureCalculator)new JwtSignatureCalculator(jwtAuthorisationGenerator, acHost, userId));
        }
        return request;
    }

    private static String getAbsoluteUrl(String url, AcHost acHost) {
        String absoluteUrl;
        if (url.matches("^[\\w]+:.*")) {
            Preconditions.checkArgument((boolean)url.startsWith(acHost.getBaseUrl()), (Object)"Absolute request URL must begin with the host base URL");
            absoluteUrl = url;
        } else {
            absoluteUrl = acHost.getBaseUrl() + url;
        }
        return absoluteUrl;
    }

    public static AcHost getAcHost() {
        return (AcHost)AC.getHttpContext().args.get("ac_host");
    }

    public static AcHost getAcHostOrThrow() {
        AcHost acHost = AC.getAcHost();
        return (AcHost)Preconditions.checkNotNull((Object)acHost);
    }

    public static AcHost setAcHost(String consumerKey) {
        return AC.setAcHost((AcHost)AC.getAcHost(consumerKey).getOrError(Suppliers.ofInstance((Object)"An error occurred getting the host application")));
    }

    public static Option<AcHost> getAcHost(String consumerKey) {
        try {
            return acHostService.findByKey(consumerKey);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void refreshToken(boolean allowInsecurePolling) {
        Token token = new Token(AC.getAcHost().getKey(), AC.getUser(), System.currentTimeMillis(), allowInsecurePolling);
        String jsonToken = Base64.encodeBase64String((byte[])token.toJson().toString().getBytes());
        String encryptedToken = Crypto.encryptAES((String)jsonToken);
        AC.getHttpContext().args.put("ac_token", encryptedToken);
    }

    public static Option<Token> validateToken(String encryptedToken, boolean allowInsecurePolling) {
        try {
            String decrypted = Crypto.decryptAES((String)encryptedToken);
            Token token = Token.fromJson(Json.parse((String)new String(Base64.decodeBase64((String)decrypted))));
            if (!allowInsecurePolling && token.isAllowInsecurePolling()) {
                return Option.none();
            }
            if (token != null && System.currentTimeMillis() - tokenExpiry <= token.getTimestamp()) {
                return Option.some((Object)token);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Option.none();
    }

    public static Option<String> getToken() {
        return Option.option((Object)((String)AC.getHttpContext().args.get("ac_token")));
    }

    static AcHost setAcHost(AcHost host) {
        AC.getHttpContext().args.put("ac_host", host);
        return host;
    }

    private static Http.Context getHttpContext() {
        return Http.Context.current();
    }

    static {
        jwtAuthorisationGenerator = JwtAuthConfig.getJwtAuthorizationGenerator();
        acHostService = InjectorFactory.getAcHostService();
    }
}

