/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.jsonrpc;

import com.atlassian.confluence.plugin.descriptor.rpc.SoapModuleDescriptor;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.rpc.jsonrpc.JsonRpcFilter;
import com.atlassian.rpc.jsonrpc.SoapModuleMethodMapper;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.voorhees.ErrorCode;
import com.atlassian.voorhees.JsonError;
import com.atlassian.voorhees.JsonRpcHandler;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceJsonRpcFilter
extends JsonRpcFilter<SoapModuleDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceJsonRpcFilter.class);
    private final SettingsManager settingsManager;

    public ConfluenceJsonRpcFilter(@ComponentImport PluginEventManager pluginEventManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport I18nResolver i18nResolver, @ComponentImport SettingsManager settingsManager) {
        super(pluginEventManager, pluginAccessor, i18nResolver);
        this.settingsManager = settingsManager;
    }

    @Override
    protected void register(SoapModuleDescriptor soapModule) {
        try {
            this.register(soapModule.getCompleteKey(), soapModule.getServicePath(), new JsonRpcHandler(new SoapModuleMethodMapper(soapModule.getModule(), soapModule.getPublishedInterface(), soapModule.isAuthenticated()), this.i18nAdapter));
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to register SOAP module " + soapModule.getCompleteKey() + " because published interface could not be instantiated. " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Class<SoapModuleDescriptor> getModuleDescriptorClass() {
        return SoapModuleDescriptor.class;
    }

    @Override
    public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain) throws IOException, ServletException {
        if (AuthenticatedUserThreadLocal.getUser() == null && !this.settingsManager.getGlobalSettings().isAllowRemoteApiAnonymous()) {
            this.showError(rs);
            return;
        }
        super.doFilter(rq, rs, chain);
    }

    private void showError(ServletResponse rs) throws IOException {
        HttpServletResponse response = (HttpServletResponse)rs;
        response.setContentType("application/json");
        response.setStatus(200);
        new ObjectMapper().writeValue(response.getWriter(), (Object)new JsonError(ErrorCode.INVALID_REQUEST, "Anonymous RPC access is disabled on this server"));
    }
}

