/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.templates;

import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugin.templates.export.TemplatePackage;
import com.atlassian.confluence.plugin.templates.export.TemplatePackageException;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatePackageManager {
    private static final Logger log = LoggerFactory.getLogger(TemplatePackageManager.class);
    private PageTemplateManager templateManager;
    private Iterable<TemplatePackage> packages;
    private SpaceManager spaceManager;
    private XhtmlContent xhtmlContent;

    public TemplatePackageManager(Iterable<TemplatePackage> packages) {
        this.packages = packages;
        if (log.isDebugEnabled()) {
            for (TemplatePackage p : packages) {
                log.debug("Template Package: " + p.getPackageName());
            }
        }
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setTemplateManager(PageTemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public PageTemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public List<PageTemplate> getInstalledTemplates() {
        return this.templateManager.getGlobalPageTemplates();
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public XhtmlContent getXhtmlContent() {
        return this.xhtmlContent;
    }

    public void setXhtmlContent(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    public Map<String, List<PageTemplate>> getAvailableTemplates() {
        HashMap<String, List<PageTemplate>> templates = new HashMap<String, List<PageTemplate>>();
        for (TemplatePackage tPackage : this.packages) {
            try {
                List<PageTemplate> pluginTemplates = tPackage.getAvailableTemplates();
                if (pluginTemplates != null) {
                    templates.put(tPackage.getPackageName(), pluginTemplates);
                    continue;
                }
                log.error("null Template package from: {}", (Object)tPackage);
            }
            catch (TemplatePackageException e) {
                log.error("Unable to get templates from: " + tPackage.getPackageName(), (Throwable)e);
            }
            catch (RuntimeException re) {
                log.error("Unable to get templates from: " + tPackage.getPackageName(), (Throwable)re);
            }
        }
        return templates;
    }

    public Map<String, PageTemplate> getTemplatesByHash() {
        HashMap<String, PageTemplate> byHash = new HashMap<String, PageTemplate>();
        for (Map.Entry<String, List<PageTemplate>> pkgEntry : this.getAvailableTemplates().entrySet()) {
            for (PageTemplate template : pkgEntry.getValue()) {
                byHash.put(String.valueOf(template.hashCode()), template);
            }
        }
        return byHash;
    }
}

